<?php



// #########################################################################################
// função geral que realiza o envio do e-mail
function envio_geral($assunto, $email_destinatario = null, $nome_destinatario = null, $mensagem, $estabelecimento = null, $toAll = false)
{
    require_once("../sendgrid/sendgrid-php.php");
    require("conn.php");

    $email = new \SendGrid\Mail\Mail();
    $email->setFrom('naoresponda@maisdigitalworkspace.com.br', 'Workspace');
    $email->setSubject($assunto);

    if ($toAll) {
        $sql_all = "SELECT email FROM usuarios WHERE status=1 AND perfil=3 AND estabelecimento=$estabelecimento";
        $exec_all = mysqli_query($conn, $sql_all);

        while($dados = mysqli_fetch_assoc($exec_all)){
            $email->addTo($dados["email"]);
        }
    }

    if (!$toAll) {
        $email->addTo($email_destinatario, $nome_destinatario);
    }

    $email->addContent("text/html", $mensagem);
    $sendgrid = new \SendGrid("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");
    try {
        $response = $sendgrid->send($email);
        if ($response->statusCode() != 202) {
            return false;
        }
        return true;
    } catch (Exception $e) {
        return false;
    }
}

// #########################################################################################
// e-mail de envio de token
function email_token($dados_usuario, $novo_email, $token, $ec_usuario)
{
    require("conn.php");
    require("ambiente.php");

    $query = "SELECT e.*, c.cor_primaria, c.cor_secundaria, c.logo, c.icone
              FROM estabelecimentos e
              INNER JOIN configs c ON e.id = c.estabelecimento
              WHERE e.id = '$ec_usuario'";

    $exec = mysqli_query($conn, $query);
    $dados_ec = mysqli_fetch_assoc($exec);
    $logo_path = explode("./",$dados_ec["logo"])[1];

    $primeiro_nome = explode(" ", $dados_usuario["nome"])[0];
    $logo = $url . $logo_path;

    $message = '
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>E-mail</title>
    </head>
    <body style="font-family: sans-serif">
        <div style="padding: 24px;">
            <center style="margin: 0 auto; width: 100%; max-width: 450px; padding: 24px">
                <img src="'.$logo.'" alt="Logo" height="40px">
                <div style="margin-top: 40px;">
                    <h2 style="color: #18181a; font-size: 24px; line-height: 32px; font-weight: 600">Olá, '.$primeiro_nome.'!</h2>
                    <p style="line-height: 140%; color: #56677D">Segue abaixo o código solicitado:</p>
                    <center style="line-height: 140%; color: #18181a; font-size: 24px; font-weight: 600; margin: 16px 0; text-align: center">' . $token . '</center>
                    <p style="line-height: 140%; color: #56677D">Não informe ou compartilhe este código com terceiros. Para sua segurança, ele é válido por apenas 24 horas.</p>
                    <p style="font-size: 13px; line-height: 20px; color: #7A899F; padding-top: 24px; margin-top: 24px; border-top: 1px solid #f2f3f5">Favor não responder este e-mail. Esta é uma mensagem automática.</p>
                </div>
            </center>
        </div>
    </body>
    </html>';

    return envio_geral("📲 Código de verificação", $novo_email, $dados_usuario["nome"], $message);
}

// #########################################################################################
// e-mail de cadastro (via do usuario)
function email_cadastro_usuario($nome_usuario, $email_usuario, $id_usuario, $ec_usuario)
{
    require("conn.php");
    require("ambiente.php");

    $query = "SELECT e.*, c.cor_primaria, c.cor_secundaria, c.logo, c.icone
              FROM estabelecimentos e
              INNER JOIN configs c ON e.id = c.estabelecimento
              WHERE e.id = '$ec_usuario'";

    $exec = mysqli_query($conn, $query);
    $dados_ec = mysqli_fetch_assoc($exec);

    $cor_primaria = $dados_ec["cor_primaria"];
    $logo_path = explode("./",$dados_ec["logo"])[1];

    $primeiro_nome = explode(" ", $nome_usuario)[0];
    $token = $email_usuario . ':' . $id_usuario . ':' . round((microtime(true) * 1000) + 86400000) . ':' . $primeiro_nome;
    $token = base64_encode($token);
    $chave = $dados_ec["chave"];
    $link = $url . "cadastrar-senha?ec=".$chave."&i=".$ec_usuario."&t=" . $token;

    $logo = $url . $logo_path;

    $message = '
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>E-mail</title>
    </head>
    <body style="font-family: sans-serif">
        <div style="padding: 24px;">
            <center style="margin: 0 auto; width: 100%; max-width: 450px; padding: 24px">
                <img src="'.$logo.'" alt="Logo" height="40px">
                <div style="margin-top: 40px;">
                    <h2 style="color: #18181a; font-size: 24px; line-height: 32px; font-weight: 600">Olá, '.$primeiro_nome.'!</h2>
                    <p style="line-height: 140%; color: #56677D">Seu cadastro no <b>'.$dados_ec["nome_fantasia"].' Workspace</b> foi realizado com sucesso! Para realizar o seu acesso, clique no botão abaixo e cadastre sua senha.</p>
                    <a style="font-size: 16px; line-height: 48px; display: inline-flex; align-items: center; justify-content: center; background-color: '.$cor_primaria.'; padding: 0 32px; height: 48px; color: #fff; text-decoration: none; border-radius: 8px; font-weight: 600; margin: 16px 0;" href="'. $link .'">Criar senha</a>
                    <p style="line-height: 140%; color: #56677D">Para sua segurança, esse link é válido por apenas 24 horas. Após esse período, você poderá criar sua senha através da opção "Recuperar" na tela de login.</p>
                    <p style="font-size: 13px; line-height: 20px; color: #7A899F; padding-top: 24px; margin-top: 24px; border-top: 1px solid #f2f3f5">Favor não responder este e-mail. Esta é uma mensagem automática.</p>
                </div>
            </center>
        </div>
    </body>
    </html>';

    return envio_geral("🎉🎉 Cadastro realizado com sucesso!", $email_usuario, $nome_usuario, $message);
}

// #########################################################################################
// e-mail de cadastro de senha
function email_cadastro_senha($nome_usuario, $email_usuario, $ec_usuario)
{
    require("conn.php");
    require("ambiente.php");

    $query = "SELECT e.*, c.cor_primaria, c.cor_secundaria, c.logo, c.icone
              FROM estabelecimentos e
              INNER JOIN configs c ON e.id = c.estabelecimento
              WHERE e.id = '$ec_usuario'";

    $exec = mysqli_query($conn, $query);
    $dados_ec = mysqli_fetch_assoc($exec);

    $chave = $dados_ec["chave"];
    $link = $url . "login?ec=" . $chave;
    $logo_path = explode("./",$dados_ec["logo"])[1];

    $cor_primaria = $dados_ec["cor_primaria"];
    $logo = $url . $logo_path;

    $message = '
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>E-mail</title>
    </head>
    <body style="font-family: sans-serif">
        <div style="padding: 24px;">
            <center style="margin: 0 auto; width: 100%; max-width: 450px; padding: 24px">
                <img src="'.$logo.'" alt="Logo" height="40px">
                <div style="margin-top: 40px;">
                    <h2 style="color: #18181a; font-size: 24px; line-height: 32px; font-weight: 600">Olá, '.$nome_usuario.'!</h2>
                    <p style="line-height: 140%; color: #56677D">Sua senha de acesso ao <b>'.$dados_ec["nome_fantasia"].' Workspace</b> foi cadastrada com sucesso! Para realizar o seu acesso, clique no botão abaixo:</p>
                    <a style="font-size: 16px; line-height: 48px; display: inline-flex; align-items: center; justify-content: center; background-color: '.$cor_primaria.'; padding: 0 32px; height: 48px; color: #fff; text-decoration: none; border-radius: 8px; font-weight: 600; margin: 16px 0;" href="'. $link .'">Acessar</a>
                    <p style="font-size: 13px; line-height: 20px; color: #7A899F; padding-top: 24px; margin-top: 24px; border-top: 1px solid #f2f3f5">Favor não responder este e-mail. Esta é uma mensagem automática.</p>
                </div>
            </center>
        </div>
    </body>
    </html>';

    return envio_geral("🔒🔐 Senha cadastrada com sucesso!", $email_usuario, $nome_usuario, $message);
}
