<?php

require_once("emails.php");

// #########################################################################################
// dicionário de true ou false
function trueOrFalse($value)
{
    $ativo = false;

    if ($value === "1") {
        $ativo = true;
    }

    return $ativo;
}

// #########################################################################################
// consulta os dados de whitelabel
function consulta_wl($chave)
{
    require("conn.php");
    require_once("version.php");

    $query = "SELECT c.*,
                     e.nome_fantasia, e.chave, e.status
                     FROM configs c
                     INNER JOIN estabelecimentos e ON c.estabelecimento = e.id
                     WHERE e.chave='$chave' AND e.status=1";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Estabelecimento não encontrado',
            'message' => 'Não encontramos nenhum estabelecimento com esta chave'
        ]);
    }

    $return = [
        'code' => 200,
        'version' => $version,
        'wl' => mysqli_fetch_assoc($exec)
    ];

    return json_encode($return);
}

// #########################################################################################
// consulta os dados do usuário logado
function consulta_usuario_logado($id_usuario)
{
    require("conn.php");

    $query = "SELECT u.id as id_usuario, u.nome, u.documento, u.email as email_usuario, u.celular, u.data_nascimento, u.foto_perfil, u.status as status_usuario, u.data_cadastro, u.ultimo_acesso,
                     e.*, e.id as id_estabelecimento,
                     p.id as id_perfil, p.perfil as perfil_usuario,
                     o.blog_bb
                     FROM usuarios u
                     INNER JOIN estabelecimentos e ON u.estabelecimento = e.id
                     INNER JOIN perfis p ON p.id = u.perfil
                     INNER JOIN opcoes o
                     WHERE u.id='$id_usuario'";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Usuário não encontrado',
            'message' => 'Não encontramos nenhum usuário com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}


// #########################################################################################
// consulta os dados do parceiro pelo id do representante
function consulta_parceiro_por_usuario($id_usuario, $id_perfil_usuario)
{
    require("conn.php");

    if ($id_perfil_usuario === 1) {
        $query = "SELECT u.id as id_usuario, u.nome, u.documento, u.email, u.celular, u.data_nascimento, u.foto_perfil, u.status as status_usuario, u.data_cadastro, u.ultimo_acesso,
                     pf.id as id_perfil, pf.perfil
                FROM usuarios u
                INNER JOIN perfis pf ON u.perfil = pf.id
                WHERE u.id='$id_usuario'";
    } else {
        $query = "SELECT e.*,
                        u.id as id_usuario, u.nome, u.documento, u.email, u.celular, u.data_nascimento, u.foto_perfil, u.status as status_usuario, u.data_cadastro, u.ultimo_acesso,
                        pf.id as id_perfil, pf.perfil
                FROM estabelecimentos e
                INNER JOIN usuarios u ON u.estabelecimento = e.id
                INNER JOIN perfis pf ON u.perfil = pf.id
                WHERE u.id='$id_usuario'";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Parceiro não encontrado',
            'message' => 'Não encontramos nenhum parceiro ligado a esse usuário'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// consulta os dados do perfil do usuário
function consulta_perfil_do_usuario($id_perfil_usuario)
{
    require("conn.php");

    $query = "SELECT * FROM perfis WHERE id='$id_perfil_usuario'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Perfil não encontrado',
            'message' => 'Não conseguimos recuperar o perfil do usuário'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// consulta os menus
function consulta_menus_ativos()
{
    require("conn.php");

    $query = "SELECT * FROM menus WHERE ativo=1 AND tipo='menu' AND mostrar=1";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Menu não encontrado',
            'message' => 'Não encontramos nenhum menu ativo'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// consulta os dados do menu por id
function consulta_menu_por_id($id_menu)
{
    require("conn.php");

    $query = "SELECT * FROM menus WHERE id='$id_menu'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Menu não encontrado',
            'message' => 'Não encontramos nenhum menu ativo'
        ]);
    }

    $menu = mysqli_fetch_assoc($exec);
    return json_encode($menu);
}

// #########################################################################################
// consulta os menus de cada perfil
function consulta_menus_ativos_por_perfil($id_perfil)
{
    require("conn.php");

    $query = "SELECT menus.* FROM permissoes
            INNER JOIN menus ON menus.id = permissoes.id_menu
            INNER JOIN perfis ON perfis.id = permissoes.id_perfil
            WHERE permissoes.id_perfil='$id_perfil' AND menus.mostrar=1 ORDER BY menus.ordem";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Menu não encontrado',
            'message' => 'Não encontramos nenhum menu ligado a esse usuário'
        ]);
    }

    $menus = [
        'code' => 200,
        'list' => []
    ];

    while ($menu = mysqli_fetch_assoc($exec)) {

        if (trueOrFalse($menu["ativo"])) {
            array_push($menus['list'], $menu);
        }
    }

    return json_encode($menus);
}

// #########################################################################################
// consulta a permissão de acesso ao menu
function consulta_permissao_menu($id_perfil, $page)
{
    require("conn.php");

    $query = "SELECT menus.* FROM permissoes
                INNER JOIN menus ON menus.id = permissoes.id_menu
                INNER JOIN perfis ON perfis.id = permissoes.id_perfil
                WHERE permissoes.id_perfil='$id_perfil' AND menus.link LIKE '$page'";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    $response = true;

    if ($res === 0) {
        $response = false;
    }

    return $response;
}

// #########################################################################################
// consulta foto de perfil
function consulta_foto_usuario($id_usuario)
{
    require("conn.php");

    $query = "SELECT foto_perfil FROM usuarios WHERE id='$id_usuario'";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Usuário não encontrado',
            'message' => 'Não encontramos nenhum usuário com o ID informado'
        ]);
    }

    $dados = mysqli_fetch_assoc($exec);
    $foto = $dados["foto_perfil"];

    if ($foto === "" || $foto === null || empty($foto)) {
        return null;
    }

    return $foto;
}

// #########################################################################################
// atualiza dados do usuário
function atualiza_dados_usuario($id_usuario)
{
    require("conn.php");

    $nome = filter_var($_POST["nome"]);
    $cpf = filter_var($_POST["cpf"]);
    $celular = filter_var($_POST["celular"]);
    $data_nascimento = filter_var($_POST["data_nascimento"]);
    $delete_photo = filter_var($_POST["delete_photo"]);
    $img = $_FILES["foto_perfil"];

    $timestamp = date('dmYHis');
    $foto_bd = consulta_foto_usuario($id_usuario);

    if ($img["name"] === "" && $delete_photo === "nao") {
        $foto_perfil_salva = $foto_bd;
    } else if ($img["name"] === "" && $delete_photo === "sim") {
        $foto_perfil_salva = null;
    } else {
        if ($foto_bd != "" || $foto_bd != null) {
            unlink("." . $foto_bd);
        }
        $cpf_formatado = str_replace([".", "-"], "", $cpf);
        $foto_perfil = "../assets/img/avatars/" . $cpf_formatado . $timestamp;
        move_uploaded_file($img["tmp_name"], $foto_perfil);
        $foto_perfil_salva = "./assets/img/avatars/" . $cpf_formatado . $timestamp;
    }

    $query = "UPDATE usuarios SET
                nome = '$nome',
                documento = '$cpf',
                celular = '$celular',
                data_nascimento = '$data_nascimento',
                foto_perfil = '$foto_perfil_salva'
             WHERE id='$id_usuario'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Usuário atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// formata as datas vindas do banco de dados
function formata_data($data)
{
    return date('d/m/Y H:i:s', strtotime($data));
}

// #########################################################################################
// atualiza senha do usuário
function atualiza_senha($id_usuario)
{
    require("conn.php");

    $senha_atual = filter_var($_POST["senha_atual"]);
    $nova_senha = filter_var($_POST["nova_senha"]);

    $query = "SELECT senha FROM usuarios WHERE id='$id_usuario'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Usuário não encontrado',
            'message' => 'Não encontramos nenhum usuário com o ID informado'
        ]);
    }

    $dados = mysqli_fetch_assoc($exec);
    $hash = $dados["senha"];

    if (!password_verify($senha_atual, $hash)) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Inválido',
            'message' => 'A senha atual está incorreta'
        ]);
    }

    $novo_hash = password_hash($nova_senha, PASSWORD_DEFAULT);

    $query = "UPDATE usuarios SET senha = '$novo_hash' WHERE id='$id_usuario'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Usuário atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// gera token 2fa
function gera_token_2fa($dados_usuario)
{
    require("conn.php");

    $ec_usuario = $dados_usuario["estabelecimento"];

    $email = filter_var($_POST["novo_email"]);
    $token = rand(100000, 999999);

    $query = "SELECT nome, email FROM usuarios WHERE email='$email'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'E-mail cadastrado',
            'message' => 'E-mail já cadastrado'
        ]);
    }

    $query = "SELECT email FROM 2fa WHERE email='$email'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        $query = "UPDATE 2fa SET token = '$token', expire = NOW() + INTERVAL 24 HOUR WHERE email='$email'";
        $exec = mysqli_query($conn, $query);

        if (!$exec) {
            return json_encode([
                'code' => 502,
                'type' => 'error',
                'title' => 'Erro ao gerar código',
                'message' => 'Não conseguimos gerar o código de verificação'
            ]);
        }

        $email_enviado = email_token($dados_usuario, $email, $token, $ec_usuario);

        if (!$email_enviado) {
            return json_encode([
                'code' => 502,
                'type' => 'error',
                'title' => 'Erro ao enviar e-mail',
                'message' => 'Não conseguimos enviar o e-mail'
            ]);
        }

        return json_encode([
            'code' => 200,
            'type' => 'success',
            'title' => 'Código gerado',
            'message' => 'Código enviado com sucesso',
            'token' => $token
        ]);
    }

    $query = "INSERT INTO 2fa (email, token, expire) VALUES ('$email','$token', NOW() + INTERVAL 24 HOUR)";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao gerar código',
            'message' => 'Não conseguimos gerar o código de verificação'
        ]);
    }

    $email_enviado = email_token($dados_usuario, $email, $token, $ec_usuario);

    if (!$email_enviado) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao enviar e-mail',
            'message' => 'Não conseguimos enviar o e-mail'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Código gerado',
        'message' => 'Código gerado com sucesso',
        'token' => $token
    ]);
}

// #########################################################################################
// gera token 2fa senha
function gera_token_2fa_senha($ec)
{

    require("conn.php");

    $email = filter_var($_POST["email_cadastrado"]);
    $token = rand(100000, 999999);

    $query = "SELECT * FROM usuarios WHERE email='$email'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'E-mail não encontrado',
            'message' => 'Informe o e-mail cadastrado em sua conta'
        ]);
    }

    $dados_usuario = mysqli_fetch_assoc($exec);

    $query = "SELECT email FROM 2fa WHERE email='$email'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        $query = "UPDATE 2fa SET token = '$token', expire = NOW() + INTERVAL 24 HOUR WHERE email='$email'";
        $exec = mysqli_query($conn, $query);

        if (!$exec) {
            return json_encode([
                'code' => 502,
                'type' => 'error',
                'title' => 'Erro ao gerar código',
                'message' => 'Não conseguimos gerar o código de verificação'
            ]);
        }

        $email_enviado = email_token($dados_usuario, $email, $token, $ec);

        if (!$email_enviado) {
            return json_encode([
                'code' => 502,
                'type' => 'error',
                'title' => 'Erro ao enviar e-mail',
                'message' => 'Não conseguimos enviar o e-mail'
            ]);
        }

        return json_encode([
            'code' => 200,
            'type' => 'success',
            'title' => 'Código gerado',
            'message' => 'Código enviado com sucesso',
            'token' => $token
        ]);
    }

    $query = "INSERT INTO 2fa (email, token, expire) VALUES ('$email','$token', NOW() + INTERVAL 24 HOUR)";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao gerar código',
            'message' => 'Não conseguimos gerar o código de verificação'
        ]);
    }

    $email_enviado = email_token($dados_usuario, $email, $token, $ec);

    if (!$email_enviado) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao enviar e-mail',
            'message' => 'Não conseguimos enviar o e-mail'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Código gerado',
        'message' => 'Código enviado com sucesso',
        'token' => $token
    ]);
}

// #########################################################################################
// atualiza email usuario
function atualiza_email_usuario($id_usuario)
{
    require("conn.php");

    $email = filter_var($_POST["novo_email"]);
    $token = filter_var($_POST["token"]);

    $query = "SELECT * FROM 2fa WHERE email='$email' AND token='$token' AND expire > NOW()";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Código inválido',
            'message' => 'Código inválido ou expirado'
        ]);
    }

    $query = "UPDATE usuarios SET email = '$email' WHERE id='$id_usuario'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao alterar',
            'message' => 'Não conseguimos alterar o e-mail'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'E-mail atualizado',
        'message' => 'E-mail alterado com sucesso'
    ]);
}

// #########################################################################################
// encaminha alteração de senha
function redireciona_alterar_senha($chave_ec)
{
    require("conn.php");

    $email = filter_var($_POST["email_cadastrado"]);
    $token = filter_var($_POST["token"]);

    $query = "SELECT * FROM 2fa WHERE email='$email' AND token='$token' AND expire > NOW()";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Código inválido',
            'message' => 'Código inválido ou expirado'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Código válido',
        'message' => 'Código válido. Redirecionando...',
        'token' => $token,
        'route' => './recuperar-senha?ec=' . $chave_ec
    ]);
}

// #########################################################################################
// recupera senha do usuário
function recupera_senha()
{
    require("conn.php");

    $nova_senha = filter_var($_POST["nova_senha"]);
    $token = filter_var($_POST["token"]);

    $query = "SELECT * FROM 2fa WHERE token='$token' AND expire > NOW()";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Link expirado',
            'message' => 'Esse link expirou, repita o processo.'
        ]);
    }

    $email_usuario = mysqli_fetch_assoc($exec)["email"];
    $novo_hash = password_hash($nova_senha, PASSWORD_DEFAULT);

    $query = "UPDATE usuarios SET senha = '$novo_hash' WHERE email='$email_usuario'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar a senha'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Usuário atualizado',
        'message' => 'Senha atualizada com sucesso',
        'route' => './sair'
    ]);
}

// #########################################################################################
// cadastra estabelecimento
function cadastra_estabelecimento()
{
    require("conn.php");

    // dados do estabelecimento
    $cnpj = filter_var($_POST["cnpj"]);
    $razao_social = filter_var($_POST["razao_social"]);
    $nome_fantasia = filter_var($_POST["nome_fantasia"]);
    $email = filter_var($_POST["email"]);
    $site = filter_var($_POST["site"]);
    $cep = filter_var($_POST["cep"]);
    $logradouro = filter_var($_POST["logradouro"]);
    $numero = filter_var($_POST["numero"]);
    $complemento = filter_var($_POST["complemento"]);
    $bairro = filter_var($_POST["bairro"]);
    $cidade = filter_var($_POST["cidade"]);
    $uf = filter_var($_POST["uf"]);
    $chave = filter_var($_POST["chave"]);
    $status = 1;

    $cor_primaria = filter_var($_POST["cor_primaria"]);
    $cor_secundaria = filter_var($_POST["cor_secundaria"]);
    $logomarca = $_FILES["logo"];
    $favicon = $_FILES["icone"];

    // verifica se já existe algum estabelecimento cadastrado
    $query = "SELECT * FROM estabelecimentos WHERE cnpj='$cnpj'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Parceiro cadastrado',
            'message' => 'Estabelecimento já cadastrado com este CNPJ'
        ]);
    }

    // verifica se já existe algum estabelecimento cadastrado com a chave informada
    $query = "SELECT * FROM estabelecimentos WHERE chave='$chave'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Chave cadastrada',
            'message' => 'A chave informada já está em uso'
        ]);
    }

    $query = "INSERT INTO estabelecimentos
                    (cnpj, razao_social, email, nome_fantasia, site, cep, logradouro, numero, complemento, bairro, cidade, uf, status, data_cadastro, chave)
                    VALUES ('$cnpj','$razao_social', '$email', '$nome_fantasia','$site','$cep','$logradouro','$numero','$complemento','$bairro','$cidade','$uf','$status',NOW(),'$chave')";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Erro ao realizar o cadastro do estabelecimento'
        ]);
    }

    $id_estabelecimento_cadastrado = mysqli_insert_id($conn);
    $cnpj_formatado = str_replace([".", "-", "/"], "", $cnpj);

    $logo = "../assets/img/wl/ec-" . $cnpj_formatado . "-logo.png";
    $logo_bd = "./assets/img/wl/ec-" . $cnpj_formatado . "-logo.png";
    move_uploaded_file($logomarca["tmp_name"], $logo);

    $icone = "../assets/img/wl/ec-" . $cnpj_formatado . "-favicon.png";
    $icone_bd = "./assets/img/wl/ec-" . $cnpj_formatado . "-favicon.png";
    move_uploaded_file($favicon["tmp_name"], $icone);

    $query = "INSERT INTO configs
                    (cor_primaria, cor_secundaria, logo, icone, estabelecimento)
                    VALUES ('$cor_primaria','$cor_secundaria','$logo_bd','$icone_bd','$id_estabelecimento_cadastrado')";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Erro ao cadastrar o label do EC'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// recupera estabelecimentos
function recupera_estabelecimentos($id = null)
{
    require("conn.php");

    if ($id != null) {
        $query = "SELECT * FROM estabelecimentos WHERE id=$id";
    } else {
        $query = "SELECT * FROM estabelecimentos";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum estabelecimento encontrado',
            'message' => 'Nenhum estabelecimento encontrado'
        ];
    }

    $estabelecimentos = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($estabelecimentos["list"], $dados);
    }

    return $estabelecimentos;
}

// #########################################################################################
// cadastra senha do usuário
function cadastra_senha($id_ec)
{
    require("conn.php");

    $senha = $_POST["senha"];
    $id = $_POST["id_usuario"];
    $email = $_POST["email_usuario"];
    $expire = $_POST["expire"];
    $nome = $_POST["nome_usuario"];

    $dados_ec = recupera_estabelecimentos($id_ec);

    $query = "SELECT senha FROM usuarios WHERE id='$id'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Usuário não encontrado',
            'message' => 'Não encontramos nenhum usuário'
        ]);
    }

    $time = round(microtime(true) * 1000);

    if ($time > $expire) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Link expirado',
            'message' => 'Link expirado. Tente novamente'
        ]);
    }

    $hash = password_hash($senha, PASSWORD_DEFAULT);

    $query = "UPDATE usuarios SET senha='$hash', status=1 WHERE id='$id'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos cadastrar a senha'
        ]);
    }

    email_cadastro_senha($nome, $email, $id_ec);

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Senha cadastrada',
        'message' => 'Senha cadastrada com sucesso',
        'route' => './login?ec=' . $dados_ec["list"][0]["chave"]
    ]);
}

// #########################################################################################
// consulta os dados do estabelecimento pelo id
function consulta_estabelecimento($id)
{
    require("conn.php");

    $query = "SELECT e.*, c.cor_primaria, c.cor_secundaria, c.logo, c.icone
              FROM estabelecimentos e
              INNER JOIN configs c ON e.id = c.estabelecimento
              WHERE e.id = '$id'";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);
    $dados = mysqli_fetch_assoc($exec);

    $query_users = "SELECT id FROM usuarios WHERE estabelecimento = '$id' AND perfil = 3";
    $exec_users = mysqli_query($conn, $query_users);
    $usuarios = mysqli_num_rows($exec_users);

    $qtd_usuarios = [
        "qtd_usuarios" => $usuarios
    ];

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Estabelecimento não encontrado',
            'message' => 'Não encontramos nenhum estabelecimento com esse id'
        ]);
    }

    return $dados + $qtd_usuarios;
}

// #########################################################################################
// consulta o email do estabelecimento pelo id
function consulta_email_ec($id)
{
    require("conn.php");

    $query = "SELECT e.nome_fantasia, e.id, u.email, u.nome
              FROM estabelecimentos e
              INNER JOIN usuarios u ON u.estabelecimento = e.id
              WHERE e.id = '$id'
              AND u.perfil = 2";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'E-mail não encontrado',
            'message' => 'Não encontramos nenhum email cadastrado para este EC'
        ];
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// altera o status do estabelecimento
function altera_status_estabelecimento($id_estabelecimento, $status)
{
    require("conn.php");

    $query = "UPDATE estabelecimentos SET status='$status' WHERE id='$id_estabelecimento'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Erro ao atualizar o status',
            'message' => 'Não conseguimos atualizar o status'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Status atualizado',
        'message' => 'Status alterado com sucesso'
    ]);
}

// #########################################################################################
// consulta logo do estabelecimento
function consulta_logo_ec($id_estabelecimento)
{
    require("conn.php");

    $query = "SELECT c.logo, c.icone FROM configs c INNER JOIN estabelecimentos e ON e.id = c.estabelecimento WHERE e.id='$id_estabelecimento'";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Usuário não encontrado',
            'message' => 'Não encontramos nenhum dado'
        ]);
    }

    $dados = mysqli_fetch_assoc($exec);
    $logo = $dados["logo"];
    $icone = $dados["icone"];

    $logos = [
        "logo" => $logo,
        "icone" => $icone
    ];

    if ($logo === "" || $logo === null || empty($logo) || $icone === "" || $icone === null || empty($icone)) {
        return null;
    }

    return $logos;
}

// #########################################################################################
// atualiza dados do estabelecimento
function atualiza_dados_estabelecimento($id_estabelecimento)
{
    require("conn.php");

    // dados do estabelecimento
    $cnpj = filter_var($_POST["cnpj"]);
    $razao_social = filter_var($_POST["razao_social"]);
    $nome_fantasia = filter_var($_POST["nome_fantasia"]);
    $email = filter_var($_POST["email"]);
    $site = filter_var($_POST["site"]);
    $cep = filter_var($_POST["cep"]);
    $logradouro = filter_var($_POST["logradouro"]);
    $numero = filter_var($_POST["numero"]);
    $complemento = filter_var($_POST["complemento"]);
    $bairro = filter_var($_POST["bairro"]);
    $cidade = filter_var($_POST["cidade"]);
    $uf = filter_var($_POST["uf"]);
    $chave = filter_var($_POST["chave"]);

    $cor_primaria = filter_var($_POST["cor_primaria"]);
    $cor_secundaria = filter_var($_POST["cor_secundaria"]);
    $logomarca = $_FILES["logo"];
    $favicon = $_FILES["icone"];

    $logos_bd = consulta_logo_ec($id_estabelecimento);
    $cnpj_formatado = str_replace([".", "-", "/"], "", $cnpj);

    $query = "UPDATE estabelecimentos SET
                cnpj = '$cnpj',
                razao_social = '$razao_social',
                email = '$email',
                nome_fantasia = '$nome_fantasia',
                site = '$site',
                cep = '$cep',
                logradouro = '$logradouro',
                numero = '$numero',
                complemento = '$complemento',
                bairro = '$bairro',
                cidade = '$cidade',
                uf = '$uf',
                chave = '$chave'
             WHERE id='$id_estabelecimento'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados do EC'
        ]);
    }

    $stringEC = "ec-";

    if ($id_estabelecimento == 1) {
        $stringEC = "";
    }

    if ($logomarca["name"] === "") {
        $logo_bd = $logos_bd["logo"];
    } else {
        if ($logos_bd["logo"] != "" || $logos_bd["logo"] != null) {
            unlink("." . $logos_bd["logo"]);
        }
        $logo = "../assets/img/wl/" . $stringEC . $cnpj_formatado . "-logo.png";
        $logo_bd = "./assets/img/wl/" . $stringEC . $cnpj_formatado . "-logo.png";
        move_uploaded_file($logomarca["tmp_name"], $logo);
    }

    if ($favicon["name"] === "") {
        $icone_bd = $logos_bd["icone"];
    } else {
        if ($logos_bd["icone"] != "" || $logos_bd["icone"] != null) {
            unlink("." . $logos_bd["icone"]);
        }
        $icone = "../assets/img/wl/" . $stringEC . $cnpj_formatado . "-favicon.png";
        $icone_bd = "./assets/img/wl/" . $stringEC . $cnpj_formatado . "-favicon.png";
        move_uploaded_file($favicon["tmp_name"], $icone);
    }

    $query = "UPDATE configs SET
                cor_primaria = '$cor_primaria',
                cor_secundaria = '$cor_secundaria',
                logo = '$logo_bd',
                icone = '$icone_bd'
             WHERE estabelecimento='$id_estabelecimento'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar a label do EC'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Usuário atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// atualiza dados do estabelecimento
function atualiza_brand_estabelecimento($id_estabelecimento, $cnpj)
{
    require("conn.php");

    $cor_primaria = filter_var($_POST["cor_primaria"]);
    $cor_secundaria = filter_var($_POST["cor_secundaria"]);
    $logomarca = $_FILES["logo"];
    $favicon = $_FILES["icone"];

    $logos_bd = consulta_logo_ec($id_estabelecimento);
    $cnpj_formatado = str_replace([".", "-", "/"], "", $cnpj);

    if ($logomarca["name"] === "") {
        $logo_bd = $logos_bd["logo"];
    } else {
        if ($logos_bd["logo"] != "" || $logos_bd["logo"] != null) {
            unlink("." . $logos_bd["logo"]);
        }
        $logo = "../assets/img/wl/" . $cnpj_formatado . "-logo.png";
        $logo_bd = "./assets/img/wl/" . $cnpj_formatado . "-logo.png";
        move_uploaded_file($logomarca["tmp_name"], $logo);
    }

    if ($favicon["name"] === "") {
        $icone_bd = $logos_bd["icone"];
    } else {
        if ($logos_bd["icone"] != "" || $logos_bd["icone"] != null) {
            unlink("." . $logos_bd["icone"]);
        }
        $icone = "../assets/img/wl/" . $cnpj_formatado . "-favicon.png";
        $icone_bd = "./assets/img/wl/" . $cnpj_formatado . "-favicon.png";
        move_uploaded_file($favicon["tmp_name"], $icone);
    }

    $query = "UPDATE configs SET
                cor_primaria = '$cor_primaria',
                cor_secundaria = '$cor_secundaria',
                logo = '$logo_bd',
                icone = '$icone_bd'
             WHERE estabelecimento='$id_estabelecimento'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Erro ao atualizar'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Usuário atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// recupera recados
function recupera_recados($id_estabelecimento, $limit = null, $all = 0)
{
    require("conn.php");

    if ($limit != null) {
        $limitString = " LIMIT " . $limit;
    } else {
        $limitString = "";
    }

    if ($all != 0) {
        $allString = " IN (1, $id_estabelecimento) ";
    } else {
        $allString = " = $id_estabelecimento ";
    }

    $query = "SELECT r.*, e.nome_fantasia, c.icone
              FROM recados r
              INNER JOIN estabelecimentos e
              ON r.estabelecimento = e.id
              INNER JOIN configs c
              ON r.estabelecimento = c.estabelecimento
              WHERE e.id" . $allString . "ORDER BY r.id DESC" . $limitString;
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum recado encontrado',
            'message' => 'Nenhum recado encontrado'
        ]);
    }

    $recados = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];


    while ($dados = mysqli_fetch_assoc($exec)) {

        $estabelecimento = [
            "id" => $dados["id"],
            "data" => formata_data($dados["data"]),
            "titulo" => $dados["titulo"],
            "recado" => $dados["recado"],
            "anexos" => [
                "link" => $dados["link"],
                "arquivo" => $dados["arquivo"],
                "imagem" => $dados["imagem"]
            ],
            "estabelecimento" => [
                "id" => $dados["id"],
                "nome_fantasia" => $dados["nome_fantasia"],
                "icone" => $dados["icone"]
            ]
        ];

        array_push($recados["list"], $estabelecimento);
    }

    return json_encode($recados);
}

// #########################################################################################
// pega a extensão do arquivo
function file_type($path)
{
    $filename_array = explode(".", $path);
    $file_type = end($filename_array);
    return $file_type;
}

// #########################################################################################
// cadastra recado
function cadastra_recado()
{
    require("conn.php");

    // dados do recado
    $titulo = $_POST["titulo"];
    $recado = $_POST["recado"];
    $link = $_POST["link"];
    $arquivo = $_FILES["arquivo"];
    $imagem = $_FILES["imagem"];
    $estabelecimento = $_POST["estabelecimento"];

    if ($arquivo["name"] != "") {
        $arquivo_path = "../assets/docs/recados/" . $arquivo["name"];
        $arquivo_bd = "./assets/docs/recados/" . $arquivo["name"];
        move_uploaded_file($arquivo["tmp_name"], $arquivo_path);
    } else {
        $arquivo_bd = "";
    }

    if ($imagem["name"] != "") {
        $imagem_path = "../assets/img/recados/" . $imagem["name"];
        $imagem_bd = "./assets/img/recados/" . $imagem["name"];
        move_uploaded_file($imagem["tmp_name"], $imagem_path);
    } else {
        $imagem_bd = "";
    }

    $query = "INSERT INTO recados
                    (data, titulo, recado, link, arquivo, imagem, estabelecimento)
                    VALUES (NOW(),'$titulo','$recado','$link','$arquivo_bd','$imagem_bd','$estabelecimento')";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Erro ao realizar o cadastro do recado'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// consulta os dados do recado pelo id
function consulta_recado($id)
{
    require("conn.php");

    $query = "SELECT r.*, e.id as estabelecimento
              FROM recados r
              INNER JOIN estabelecimentos e ON r.estabelecimento = e.id
              WHERE r.id = '$id'";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Recado não encontrado',
            'message' => 'Não encontramos nenhum recado com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// atualiza dados do recado
function atualiza_recado($id_recado)
{
    require("conn.php");

    // dados do recado
    $titulo = $_POST["titulo"];
    $recado = $_POST["recado"];
    $link = $_POST["link"];
    $delete_imagem = $_POST["delete_imagem"];
    $delete_arquivo = $_POST["delete_arquivo"];
    $arquivo = $_FILES["arquivo"];
    $imagem = $_FILES["imagem"];

    if ($imagem["name"] != "") {
        $query = "SELECT imagem FROM recados WHERE id = $id_recado";
        $exec = mysqli_query($conn, $query);
        $res = mysqli_fetch_assoc($exec);
        if ($res["imagem"] != "" || $res["imagem"] != null) {
            unlink("." . $res["imagem"]);
        }

        $imagem_path = "../assets/img/recados/" . $imagem["name"];
        $imagem_bd = "./assets/img/recados/" . $imagem["name"];
        move_uploaded_file($imagem["tmp_name"], $imagem_path);
    } else {
        if ($delete_imagem == "sim") {
            $imagem_bd = null;
            $query = "SELECT imagem FROM recados WHERE id = $id_recado";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            unlink("." . $res["imagem"]);
        } else {
            $query = "SELECT imagem FROM recados WHERE id = $id_recado";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            $imagem_bd = $res["imagem"];
        }
    }

    if ($arquivo["name"] != "") {
        $query = "SELECT arquivo FROM recados WHERE id = $id_recado";
        $exec = mysqli_query($conn, $query);
        $res = mysqli_fetch_assoc($exec);
        if ($res["arquivo"] != "" || $res["arquivo"] != null) {
            unlink("." . $res["arquivo"]);
        }

        $arquivo_path = "../assets/docs/recados/" . $arquivo["name"];
        $arquivo_bd = "./assets/docs/recados/" . $arquivo["name"];
        move_uploaded_file($arquivo["tmp_name"], $arquivo_path);
    } else {
        if ($delete_arquivo == "sim") {
            $arquivo_bd = null;
            $query = "SELECT arquivo FROM recados WHERE id = $id_recado";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            unlink("." . $res["arquivo"]);
        } else {
            $query = "SELECT arquivo FROM recados WHERE id = $id_recado";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            $arquivo_bd = $res["arquivo"];
        }
    }

    $query = "UPDATE recados SET
                data = NOW(),
                titulo = '$titulo',
                recado = '$recado',
                link = '$link',
                arquivo = '$arquivo_bd',
                imagem = '$imagem_bd'
             WHERE id='$id_recado'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados do recado'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Recado atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// deleta o recado
function deleta_recado($id)
{
    require("conn.php");

    $query = "DELETE FROM recados WHERE id = '$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Recado não encontrado',
            'message' => 'Não encontramos nenhum recado com esse id'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'error',
        'title' => 'Recado deletado',
        'message' => 'Recado deletado com sucesso'
    ]);
}

// #########################################################################################
// recupera recados
function recupera_usuarios($id_estabelecimento, $limit = null, $exclude = null, $perfil = null)
{
    require("conn.php");

    if ($limit != null && $exclude != null) {
        $query = "SELECT u.*, p.perfil as perfil_user FROM usuarios u INNER JOIN perfis p ON u.perfil = p.id WHERE u.estabelecimento = $id_estabelecimento AND u.perfil=3 AND u.id <> $exclude  ORDER BY u.nome LIMIT $limit";
    } else if ($perfil != null) {
        $query = "SELECT u.*, p.perfil as perfil_user FROM usuarios u INNER JOIN perfis p ON u.perfil = p.id WHERE u.estabelecimento = $id_estabelecimento ORDER BY u.nome";
    } else {
        $query = "SELECT u.*, p.perfil as perfil_user FROM usuarios u INNER JOIN perfis p ON u.perfil = p.id WHERE u.estabelecimento = $id_estabelecimento AND u.perfil = 3 ORDER BY u.nome";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            "estabelecimento" => $id_estabelecimento,
            'title' => 'Nenhum usuário encontrado',
            'message' => 'Nenhum usuário encontrado'
        ]);
    }

    $usuarios = [
        "code" => 200,
        "estabelecimento" => $id_estabelecimento,
        "quantidade" => $res,
        "list" => []
    ];


    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($usuarios["list"], $dados);
    }

    return json_encode($usuarios);
}

// #########################################################################################
// recupera recados
function recupera_usuarios_por_status($id_estabelecimento, $status)
{
    require("conn.php");

    $query = "SELECT * FROM usuarios WHERE estabelecimento = $id_estabelecimento AND perfil=3 AND status = $status";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum usuário encontrado',
            'message' => 'Nenhum usuário encontrado'
        ]);
    }

    $usuarios = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];


    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($usuarios["list"], $dados);
    }

    return json_encode($usuarios);
}

// #########################################################################################
// cadastra usuário
function cadastra_usuario()
{
    require("conn.php");

    if (isset($_POST["perfil"])) {
        $perfil = filter_var($_POST["perfil"]);
    } else {
        $perfil = 3;
    }

    if (isset($_POST["ec_usuario"])) {
        $estabelecimento = filter_var($_POST["ec_usuario"]);
    } else {
        $estabelecimento = filter_var($_POST["estabelecimento"]);
    }

    // dados do usuário
    $nome = filter_var($_POST["nome"]);
    $cpf = filter_var($_POST["cpf"]);
    $data_nascimento = filter_var($_POST["data_nascimento"]);
    $celular = filter_var($_POST["celular"]);
    $email = filter_var($_POST["email"]);
    $status = 2;

    // verifica se já existe algum usuário cadastrado
    $query = "SELECT documento, email FROM usuarios WHERE documento='$cpf' OR email='$email'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Usuário cadastrado',
            'message' => 'Já existe um usuário com este CPF ou e-mail'
        ]);
    }

    $query = "INSERT INTO usuarios
                    (nome, documento, email, celular, data_nascimento, status, data_cadastro, perfil, estabelecimento)
                    VALUES ('$nome','$cpf','$email','$celular','$data_nascimento','$status',NOW(),'$perfil', '$estabelecimento')";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    $id_usuario_cadastrado = mysqli_insert_id($conn);
    $email_enviado_usuario = email_cadastro_usuario($nome, $email, $id_usuario_cadastrado, $estabelecimento);

    if (!$email_enviado_usuario) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao enviar e-mail',
            'message' => 'Não conseguimos enviar o e-mail'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// consulta os dados do usuario pelo id
function consulta_usuario($id)
{
    require("conn.php");

    $query = "SELECT * FROM usuarios WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Usuário não encontrado',
            'message' => 'Não encontramos nenhum usuário com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// altera o status do usuário
function altera_status_usuario($id, $status)
{
    require("conn.php");

    $query = "UPDATE usuarios SET status='$status' WHERE id='$id'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Erro ao atualizar o status',
            'message' => 'Não conseguimos atualizar o status'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Status atualizado',
        'message' => 'Status alterado com sucesso'
    ]);
}

// #########################################################################################
// atualiza dados do usuário
function atualiza_dados_usuario_ec($id)
{
    require("conn.php");

    // dados do usuário
    $nome = filter_var($_POST["nome"]);
    $cpf = filter_var($_POST["cpf"]);
    $data_nascimento = filter_var($_POST["data_nascimento"]);
    $celular = filter_var($_POST["celular"]);
    $email = filter_var($_POST["email"]);

    $query = "UPDATE usuarios SET
                nome = '$nome',
                documento = '$cpf',
                data_nascimento = '$data_nascimento',
                celular = '$celular',
                email = '$email'
             WHERE id='$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados do usuário'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Usuário atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// cadastra parceiro
function cadastra_parceiro()
{
    require("conn.php");

    // dados do parceiro
    $nome = filter_var($_POST["nome"]);
    $telefone = filter_var($_POST["telefone"]);
    $email = filter_var($_POST["email"]);
    $site = filter_var($_POST["site"]);
    $logo = $_FILES["logo"];

    // verifica se já existe algum parceiro cadastrado
    $query = "SELECT * FROM parceiros WHERE nome='$nome' OR telefone='$telefone' OR email='$email' OR site='$site'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Parceiro cadastrado',
            'message' => 'Este parceiro já está cadastrado'
        ]);
    }

    if ($logo["name"] != "") {
        $logo_path = "../assets/img/parceiros/" . $logo["name"];
        $logo_bd = "./assets/img/parceiros/" . $logo["name"];
        move_uploaded_file($logo["tmp_name"], $logo_path);
    } else {
        $logo_bd = "";
    }

    $query = "INSERT INTO parceiros
                    (nome, telefone, email, site, logo, status)
                    VALUES ('$nome','$telefone','$email','$site','$logo_bd',1)";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// recupera parceiros
function recupera_parceiros($status = null, $order = null)
{
    require("conn.php");

    if ($status != null && $order != null) {
        $query = "SELECT * FROM parceiros WHERE status=$status ORDER BY nome";
    } else {
        $query = "SELECT * FROM parceiros";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum parceiro encontrado',
            'message' => 'Nenhum parceiro encontrado'
        ];
    }

    $parceiros = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($parceiros["list"], $dados);
    }

    return $parceiros;
}

// #########################################################################################
// consulta os dados do parceiro pelo id
function consulta_parceiro($id)
{
    require("conn.php");

    $query = "SELECT * FROM parceiros WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Parceiro não encontrado',
            'message' => 'Não encontramos nenhum parceiro com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// atualiza dados do parceiro
function atualiza_parceiro($id_parceiro)
{
    require("conn.php");

    // dados do parceiro
    $nome = filter_var($_POST["nome"]);
    $telefone = filter_var($_POST["telefone"]);
    $email = filter_var($_POST["email"]);
    $site = filter_var($_POST["site"]);
    $logo = $_FILES["logo"];
    $delete_logo = $_POST["delete_logo"];

    if ($logo["name"] != "") {
        $query = "SELECT logo FROM parceiros WHERE id = $id_parceiro";
        $exec = mysqli_query($conn, $query);
        $res = mysqli_fetch_assoc($exec);
        if ($res["logo"] != "" || $res["logo"] != null) {
            unlink("." . $res["logo"]);
        }

        $logo_path = "../assets/img/parceiros/" . $logo["name"];
        $logo_bd = "./assets/img/parceiros/" . $logo["name"];
        move_uploaded_file($logo["tmp_name"], $logo_path);
    } else {
        if ($delete_logo == "sim") {
            $logo_bd = null;
            $query = "SELECT logo FROM parceiros WHERE id = $id_parceiro";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            unlink("." . $res["logo"]);
        } else {
            $query = "SELECT logo FROM parceiros WHERE id = $id_parceiro";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            $logo_bd = $res["logo"];
        }
    }

    $query = "UPDATE parceiros SET
                nome = '$nome',
                telefone = '$telefone',
                email = '$email',
                site = '$site',
                logo = '$logo_bd'
             WHERE id='$id_parceiro'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados do parceiro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Recado atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// altera o status do parceiro
function altera_status_parceiro($id, $status)
{
    require("conn.php");

    $query = "UPDATE parceiros SET status='$status' WHERE id='$id'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Erro ao atualizar o status',
            'message' => 'Não conseguimos atualizar o status'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Status atualizado',
        'message' => 'Status alterado com sucesso'
    ]);
}

// #########################################################################################
// cadastra portal
function cadastra_portal()
{
    require("conn.php");

    // dados do portal
    $nome = filter_var($_POST["nome"]);
    $link = filter_var($_POST["link"]);
    $ec = filter_var($_POST["ec"]);

    // verifica se já existe algum portal cadastrado
    $query = "SELECT * FROM portais WHERE nome='$nome' AND link='$link' AND estabelecimento='$ec'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Portal cadastrado',
            'message' => 'Este portal já está cadastrado'
        ]);
    }

    $query = "INSERT INTO portais
                    (nome, link, status, estabelecimento)
                    VALUES ('$nome','$link',1,'$ec')";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// recupera portais
function recupera_portais($ec, $status = null)
{
    require("conn.php");

    if ($status != null) {
        $query = "SELECT p.*, e.nome_fantasia FROM portais p INNER JOIN estabelecimentos e ON p.estabelecimento = e.id WHERE p.estabelecimento IN ($ec, 1) AND p.status=$status";
    } else {
        $query = "SELECT * FROM portais WHERE estabelecimento=$ec";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum portal encontrado',
            'message' => 'Nenhum portal encontrado'
        ];
    }

    $portais = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($portais["list"], $dados);
    }

    return $portais;
}

// #########################################################################################
// consulta os dados do portal pelo id
function consulta_portal($id)
{
    require("conn.php");

    $query = "SELECT * FROM portais WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Portal não encontrado',
            'message' => 'Não encontramos nenhum portal com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// atualiza dados do portal
function atualiza_portal($id)
{
    require("conn.php");

    // dados do portal
    $nome = filter_var($_POST["nome"]);
    $link = filter_var($_POST["link"]);
    $status = filter_var($_POST["status"]);

    $query = "UPDATE portais SET
                nome = '$nome',
                link = '$link',
                status = '$status'
             WHERE id='$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados do portal'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Recado atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// atualiza link do blog bb
function atualiza_link_blog()
{
    require("conn.php");

    // dados do link
    $link = filter_var($_POST["link"]);

    $query = "UPDATE opcoes SET blog_bb = '$link'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar o link'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Recado atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// recupera as opcoes do administrador
function recupera_opcoes()
{
    require("conn.php");

    $query = "SELECT blog_bb FROM opcoes WHERE id=1";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);
    $dados = mysqli_fetch_assoc($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhuma encontrado',
            'message' => 'Nenhum portal encontrado'
        ];
    }

    return $dados;
}

// #########################################################################################
// cadastra faq
function cadastra_faq()
{
    require("conn.php");

    // dados do faq
    $pergunta = filter_var($_POST["pergunta"]);
    $resposta = filter_var($_POST["resposta"]);
    $categoria = filter_var($_POST["categoria"]);

    if (trim($pergunta) == "" || trim($resposta) == "" || $resposta == "<p><br></p>" || trim($categoria) == "") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    // verifica se já existe algum faq cadastrado
    $query = "SELECT * FROM faq WHERE pergunta='$pergunta' OR resposta='$resposta'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Pergunta cadastrada',
            'message' => 'Esta pergunta já está cadastrada'
        ]);
    }

    $query = "INSERT INTO faq
                    (pergunta, resposta, status, categoria)
                    VALUES ('$pergunta','$resposta',1,'$categoria')";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// consulta os dados do faq pelo id
function consulta_faq($id)
{
    require("conn.php");

    $query = "SELECT * FROM faq WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Pergunta não encontrada',
            'message' => 'Não encontramos nenhuma pergunta com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// recupera faq
function recupera_faq($status = null)
{
    require("conn.php");

    if ($status != null) {
        $query = "SELECT * FROM faq WHERE status=$status";
    } else {
        $query = "SELECT * FROM faq";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhuma pergunta encontrada',
            'message' => 'Nenhuma pergunta encontrada'
        ];
    }

    $faq = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($faq["list"], $dados);
    }

    return $faq;
}

// #########################################################################################
// atualiza dados do faq
function atualiza_faq($id)
{
    require("conn.php");

    // dados do faq
    $pergunta = filter_var($_POST["pergunta"]);
    $resposta = filter_var($_POST["resposta"]);
    $categoria = filter_var($_POST["categoria"]);
    $status = filter_var($_POST["status"]);

    $query = "UPDATE faq SET
                pergunta = '$pergunta',
                resposta = '$resposta',
                categoria = '$categoria',
                status = '$status'
             WHERE id='$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados da pergunta'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Pergunta atualizada',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// recupera as categorias das faqs
function recupera_categorias_faq()
{
    require("conn.php");

    $query = "SELECT DISTINCT categoria FROM faq";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhuma categoria encontrada',
            'message' => 'Nenhuma categoria encontrada'
        ];
    }

    $categorias = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($categorias["list"], $dados["categoria"]);
    }

    return $categorias;
}

// #########################################################################################
// recupera as perguntas das faqs pela categoria
function recupera_faq_por_categoria($categoria)
{
    require("conn.php");

    $query = "SELECT * FROM faq WHERE categoria='$categoria' AND status=1";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhuma pergunta encontrada',
            'message' => 'Nenhuma pergunta encontrada'
        ];
    }

    $perguntas = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($perguntas["list"], $dados);
    }

    return $perguntas;
}

// #########################################################################################
// cadastra termo
function cadastra_termo()
{
    require("conn.php");

    // dados do termo
    $titulo = filter_var($_POST["titulo"]);
    $termo = filter_var($_POST["termo"]);
    // $categoria = filter_var($_POST["categoria"]);
    $arquivo = $_FILES["arquivo"];
    $status = 1;

    if (trim($titulo) == "" || trim($termo) == "" || $termo == "<p><br></p>") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    if ($arquivo["name"] != "") {
        $arquivo_path = "../assets/docs/" . $arquivo["name"];
        $arquivo_bd = "./assets/docs/" . $arquivo["name"];
        move_uploaded_file($arquivo["tmp_name"], $arquivo_path);
    } else {
        $arquivo_bd = "";
    }

    // verifica se já existe algum termo cadastrado
    $query = "SELECT * FROM termos WHERE titulo='$titulo' OR termo='$termo'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Termo cadastrado',
            'message' => 'Este termo já está cadastrado'
        ]);
    }

    $query = "INSERT INTO termos
                    (titulo, termo, anexo, status, data_cadastro)
                    VALUES ('$titulo','$termo','$arquivo_bd','$status',NOW())";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// consulta os dados do termo pelo id
function consulta_termo($id)
{
    require("conn.php");

    $query = "SELECT * FROM termos WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Termo não encontrado',
            'message' => 'Não encontramos nenhum termo com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// recupera termos
function recupera_termos($status = null)
{
    require("conn.php");

    if ($status != null) {
        $query = "SELECT * FROM termos WHERE status=$status";
    } else {
        $query = "SELECT * FROM termos";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum termo encontrada',
            'message' => 'Nenhum termo encontrada'
        ];
    }

    $termos = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($termos["list"], $dados);
    }

    return $termos;
}

// #########################################################################################
// atualiza dados do termo
function atualiza_termo($id)
{
    require("conn.php");

    // dados do termo
    $titulo = filter_var($_POST["titulo"]);
    $termo = filter_var($_POST["termo"]);
    $arquivo = $_FILES["arquivo"];
    $status = filter_var($_POST["status"]);
    $delete_arquivo = $_POST["delete_arquivo"];

    if (trim($titulo) == "" || trim($termo) == "" || $termo == "<p><br></p>") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    if ($arquivo["name"] != "") {
        $query = "SELECT anexo FROM termos WHERE id = $id";
        $exec = mysqli_query($conn, $query);
        $res = mysqli_fetch_assoc($exec);
        if ($res["anexo"] != "" || $res["anexo"] != null) {
            unlink("." . $res["anexo"]);
        }

        $arquivo_path = "../assets/docs/" . $arquivo["name"];
        $arquivo_bd = "./assets/docs/" . $arquivo["name"];
        move_uploaded_file($arquivo["tmp_name"], $arquivo_path);
    } else {
        if ($delete_arquivo == "sim") {
            $arquivo_bd = null;
            $query = "SELECT anexo FROM termos WHERE id = $id";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            unlink("." . $res["anexo"]);
        } else {
            $query = "SELECT anexo FROM termos WHERE id = $id";
            $exec = mysqli_query($conn, $query);
            $res = mysqli_fetch_assoc($exec);
            $arquivo_bd = $res["anexo"];
        }
    }


    $query = "UPDATE termos SET
                titulo = '$titulo',
                termo = '$termo',
                anexo = '$arquivo_bd',
                status = '$status',
                data_atualizacao = NOW()
             WHERE id='$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Pergunta atualizada',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// cadastra video
function cadastra_video()
{
    require("conn.php");

    // dados do video
    $titulo = filter_var($_POST["titulo"]);
    // $descricao = filter_var($_POST["descricao"]);
    $link = filter_var($_POST["link"]);

    $ec = filter_var($_POST["ec"]);

    if (trim($titulo) == "" || trim($link) == "") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    // verifica se já existe algum video cadastrado
    $query = "SELECT * FROM videos WHERE link='$link' OR titulo='$titulo'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Vídeo cadastrado',
            'message' => 'Este vídeo já está cadastrado'
        ]);
    }

    $query = "INSERT INTO videos
                    (titulo, link, data_cadastro, status, estabelecimento)
                    VALUES ('$titulo','$link',NOW(),1,'$ec')";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// consulta os dados do vídeo pelo id
function consulta_video($id)
{
    require("conn.php");

    $query = "SELECT * FROM videos WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Vídeo não encontrado',
            'message' => 'Não encontramos nenhum vídeo com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// recupera videos
function recupera_videos($ec, $status = null)
{
    require("conn.php");

    if ($status != null) {
        $query = "SELECT v.*, e.nome_fantasia FROM videos v INNER JOIN estabelecimentos e ON v.estabelecimento = e.id WHERE v.estabelecimento=$ec OR v.estabelecimento=1 AND v.status=$status ORDER BY v.data_cadastro DESC";
    } else {
        $query = "SELECT * FROM videos WHERE estabelecimento=$ec ORDER BY data_cadastro DESC";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum video encontrado',
            'message' => 'Nenhum video encontrado'
        ];
    }

    $videos = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($dados = mysqli_fetch_assoc($exec)) {
        array_push($videos["list"], $dados);
    }

    return $videos;
}

// #########################################################################################
// atualiza dados do video
function atualiza_video($id)
{
    require("conn.php");

    // dados do video
    $titulo = filter_var($_POST["titulo"]);
    $descricao = filter_var($_POST["descricao"]);
    $link = filter_var($_POST["link"]);
    $status = filter_var($_POST["status"]);

    if (trim($titulo) == "" || trim($link) == "") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    $query = "UPDATE videos SET
                titulo = '$titulo',
                descricao = '$descricao',
                link = '$link',
                status = '$status',
                data_cadastro = NOW()
             WHERE id='$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Pergunta atualizada',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// deleta o video
function deleta_video($id)
{
    require("conn.php");

    $query = "DELETE FROM videos WHERE id = '$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Vídeo não deletado',
            'message' => 'Não conseguimos deletar o vídeo'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'error',
        'title' => 'Vídeo deletado',
        'message' => 'Vídeo deletado com sucesso'
    ]);
}

// #########################################################################################
// cadastra manual
function cadastra_manual()
{
    require("conn.php");

    // dados do manual
    $titulo = filter_var($_POST["titulo"]);
    $descricao = filter_var($_POST["descricao"]);
    $arquivo = $_FILES["arquivo"];

    if (trim($titulo) == "" || $arquivo["name"] == "") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    // verifica se já existe algum manual cadastrado
    $query = "SELECT * FROM manuais WHERE titulo='$titulo'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res > 0) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Manual cadastrado',
            'message' => 'Este manual já está cadastrado'
        ]);
    }

    $arquivo_path = "../assets/docs/manuais/" . $arquivo["name"];
    $arquivo_bd = "./assets/docs/manuais/" . $arquivo["name"];
    move_uploaded_file($arquivo["tmp_name"], $arquivo_path);

    $query = "INSERT INTO manuais
                    (titulo, descricao, arquivo, data_cadastro, status)
                    VALUES ('$titulo','$descricao','$arquivo_bd',NOW(),1)";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Erro ao cadastrar',
            'message' => 'Não conseguimos realizar o cadastro'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}

// #########################################################################################
// recupera manuais
function recupera_manuais($status = null)
{
    require("conn.php");

    if ($status != null) {
        $query = "SELECT * FROM manuais WHERE status=$status ORDER BY titulo";
    } else {
        $query = "SELECT * FROM manuais";
    }

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return [
            'code' => 404,
            'type' => 'error',
            'title' => 'Nenhum manual encontrado',
            'message' => 'Nenhum manual encontrado'
        ];
    }

    $manuais = [
        "code" => 200,
        "quantidade" => $res,
        "list" => []
    ];

    while ($manual = mysqli_fetch_assoc($exec)) {
        array_push($manuais["list"], $manual);
    }

    return $manuais;
}

// #########################################################################################
// consulta os dados do manual pelo id
function consulta_manual($id)
{
    require("conn.php");

    $query = "SELECT * FROM manuais WHERE id=$id";

    $exec = mysqli_query($conn, $query);
    $res = mysqli_num_rows($exec);

    if ($res === 0) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Manual não encontrado',
            'message' => 'Não encontramos nenhum manual com esse id'
        ]);
    }

    return mysqli_fetch_assoc($exec);
}

// #########################################################################################
// atualiza dados do manual
function atualiza_manual($id)
{
    require("conn.php");

    // dados do manual
    $titulo = filter_var($_POST["titulo"]);
    $descricao = filter_var($_POST["descricao"]);
    $status = filter_var($_POST["status"]);
    $arquivo = $_FILES["arquivo"];

    if (trim($titulo) == "") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    if ($arquivo["name"] != "") {
        $query = "SELECT arquivo FROM manuais WHERE id = $id";
        $exec = mysqli_query($conn, $query);
        $res = mysqli_fetch_assoc($exec);
        if ($res["arquivo"] != "" || $res["arquivo"] != null) {
            unlink("." . $res["arquivo"]);
        }

        $arquivo_path = "../assets/docs/manuais/" . $arquivo["name"];
        $arquivo_bd = "./assets/docs/manuais/" . $arquivo["name"];
        move_uploaded_file($arquivo["tmp_name"], $arquivo_path);
    } else {
        $query = "SELECT arquivo FROM manuais WHERE id = $id";
        $exec = mysqli_query($conn, $query);
        $res = mysqli_fetch_assoc($exec);
        $arquivo_bd = $res["arquivo"];
    }

    $query = "UPDATE manuais SET
                titulo = '$titulo',
                descricao = '$descricao',
                arquivo = '$arquivo_bd',
                status = '$status'
             WHERE id='$id'";

    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 400,
            'type' => 'error',
            'title' => 'Erro ao atualizar',
            'message' => 'Não conseguimos atualizar os dados do manual'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Manual atualizado',
        'message' => 'Dados atualizados com sucesso'
    ]);
}

// #########################################################################################
// deleta o manual
function deleta_manual($id)
{
    require("conn.php");

    $query = "SELECT arquivo FROM manuais WHERE id='$id'";
    $exec = mysqli_query($conn, $query);
    $res = mysqli_fetch_assoc($exec);

    if ($res["arquivo"] != "" || $res["arquivo"] != null) {
        unlink("." . $res["arquivo"]);
    }

    $query = "DELETE FROM manuais WHERE id = '$id'";
    $exec = mysqli_query($conn, $query);

    if (!$exec) {
        return json_encode([
            'code' => 404,
            'type' => 'error',
            'title' => 'Manual não deletado',
            'message' => 'Não conseguimos deletar o manual'
        ]);
    }

    return json_encode([
        'code' => 200,
        'type' => 'error',
        'title' => 'Manual deletado',
        'message' => 'Manual deletado com sucesso'
    ]);
}

// #########################################################################################
// cadastra imagens de mkt
function cadastra_imagens()
{
    require("conn.php");

    // dados
    $categoria = filter_var($_POST["categoria"]);
    $ec = filter_var($_POST["estabelecimento"]);
    $imagem = $_FILES["imagem"];

    if (trim($categoria) == "" || $imagem["name"] == "") {
        return json_encode([
            'code' => 406,
            'type' => 'error',
            'title' => 'Preencha os campos',
            'message' => 'Preencha todos os campos obrigatórios'
        ]);
    }

    $qtd_imagens = count(array_filter($imagem['name']));

    for ($i = 0; $i < $qtd_imagens; $i++) {
        $nome = $imagem["name"][$i];
        $tmp = $imagem["tmp_name"][$i];
        $ext = end(explode('.', $nome));
        $uniq_name = uniqid("img_", true);

        $imagem_path = "../assets/img/mkt/" . $uniq_name . ".$ext";
        $imagem_bd = "./assets/img/mkt/" . $uniq_name . ".$ext";
        move_uploaded_file($tmp, $imagem_path);

        $query = "INSERT INTO marketing
        (titulo, descricao, arquivo, data_cadastro, status, estabelecimento)
        VALUES ('$titulo','$descricao','$arquivo_bd',NOW(),1,'$ec')";

        $exec = mysqli_query($conn, $query);

        if (!$exec) {
            return json_encode([
                'code' => 502,
                'type' => 'error',
                'title' => 'Erro ao cadastrar',
                'message' => 'Não conseguimos realizar o cadastro'
            ]);
        }
    }

    return json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Cadastro realizado',
        'message' => 'Cadastro realizado com sucesso!'
    ]);
}
