<?php

session_start();
require_once("conn.php");

if ($_POST) {

    if (empty($_POST['email']) || empty($_POST['password'])) {
        echo json_encode([
            'code' => 412,
            'type' => 'warning',
            'title' => 'Campos obrigatórios',
            'message' => 'Preencha os campos obrigatórios'
        ]);
        return false;
    }

    $email = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
    $senha = $_POST['password'];
    $ec = $_POST['id_ec'];

    $query_email = "SELECT u.*, e.chave, e.status, e.id as id_ec FROM usuarios u INNER JOIN estabelecimentos e ON u.estabelecimento = e.id WHERE u.email='$email' AND u.status=1 AND u.estabelecimento='$ec' AND e.status=1";
    $exec_email = mysqli_query($conn, $query_email);
    $res_email = mysqli_num_rows($exec_email);

    if ($res_email === 0) {
        echo json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Inválido',
            'message' => 'Usuário ou senha inválidos'
        ]);
        return false;
    }

    $data_user = mysqli_fetch_assoc($exec_email);
    $hash = $data_user['senha'];

    if (!password_verify($senha, $hash)) {
        echo json_encode([
            'code' => 502,
            'type' => 'error',
            'title' => 'Inválido',
            'message' => 'Usuário ou senha inválidos'
        ]);
        return false;
    }

    $token = $data_user['email'] . ':' . $data_user['senha'];
    $token = base64_encode($token);

    $id_user = $data_user['id'];
    $date = date('Y-m-d H:i:s', time());

    $query_date = "UPDATE usuarios SET ultimo_acesso='$date' WHERE id='$id_user'";
    $exec_date = mysqli_query($conn, $query_date);

    if (!$exec_date || mysqli_affected_rows($conn) === -1) {
        echo json_encode($msg_erro_interno);
        return false;
    }

    $_SESSION['token'] = $token;
    $_SESSION['chave'] = $data_user["chave"];
    $_SESSION['id_usuario'] = $id_user;
    $_SESSION['ec'] = $ec;

    $perfil = $data_user["perfil"];

    if ($perfil === "1") {
        $route = './estabelecimentos';
    } else if ($perfil === "2") {
        $route = './dashboard';
    } else {
        $route = './home';
    }

    echo json_encode([
        'code' => 200,
        'type' => 'success',
        'title' => 'Sucesso!',
        'message' => 'Login realizado com sucesso',
        'route' => $route
    ]);

    return true;
}
