<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Recados - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/recados.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="feed" data-route="feed">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main recados">
        <div class="inner-container">
            <div class="banner mb-3 banner-recados">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Recados</h3>
                        <p>Por aqui você vai ficar por dentro de todas as novidades da nossa empresa em primeira mão.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="load load-recados center" id="loadRecados"></div>
            </div>
            <div class="card hide" id="emptyRecados">
                <div class="empty">
                    <?php require_once("./assets/img/empty_recados.svg"); ?>
                    <p>Nenhum recado encontrado</p>
                </div>
            </div>
            <div class="section-row">
                <div class="column-60">
                    <section class="recados-list"></section>
                </div>
                <div class="column-40 sticky hide">
                    <div class="card blog">
                        <div class="conteudo">
                            <p class="titulo">Blog Mais Digital</p>
                            <p class="mb-2">Acesse e fique por dentro de todas as novidades do mundo financeiro.</p>
                            <a target="_blank" class="botao primary" id="linkAcessoBlogMaisDigital">
                                <div class="text">Acessar o blog</div>
                            </a>
                        </div>
                    </div>
                    <div class="card">
                        <div class="conteudo">
                            <div class="titulo">Parceiros Banco do Brasil</div>
                            <p class="mb-2">Saiba como os parceiros do BB podem te ajudar. Acesse agora e confira.</p>
                            <a href="./lista/parceiros" class="botao primary">
                                <div class="text">Acessar</div>
                            </a>
                        </div>
                    </div>
                    <div class="card link">
                        <div class="conteudo">
                            <p class="titulo">Link de cadastro</p>
                            <p class="margin">Envie o link abaixo para outras pessoas se cadastrarem no Workspace.</p>
                            <div class="input-container">
                                <input type="text" readonly class="input" id="link" value="">
                                <input type="hidden" id="ghost">
                                <div class="botao primary copiar small auto-width">
                                    <div class="icon"><span class="material-icons-round">copy</span></div>
                                    <div class="text">Copiar</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>
<?php require_once("model/body/modal_imagem.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>