<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Usuários - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/usuarios.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="lista-usuarios" data-route="lista-usuarios">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main usuarios">
        <div class="inner-container">
            <div class="banner mb-3 banner-usuarios">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Usuários</h3>
                        <p>Entre em contato com outras pessoas que também utilizam o nosso workspace para se atualizar sobre a empresa.</p>
                    </div>
                </div>
            </div>
            <section class="filtros mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaListaUser" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Pesquise pelo nome ou e-mail</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <div class="card">
                <div class="load load-usuarios center" id="loadUsuarios"></div>
            </div>
            <div class="card hide" id="emptyUsuarios">
                <div class="empty">
                    <?php require_once("./assets/img/empty_usuarios.svg"); ?>
                    <p>Nenhum usuário encontrado</p>
                </div>
            </div>
            <div class="card card-lista-usuarios hide">
                <div class="conteudo">
                    <ul class="lista usuarios-list"></ul>
                </div>
            </div>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>