<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Vídeos - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/videos.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="lista-videos" data-route="lista-videos">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main videos">
        <div class="inner-container">
            <div class="banner mb-3 banner-video">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Mídias</h3>
                        <p>Explore, aprenda e compartilhe - Confira fotos e vídeos que estimulam o conhecimento para o sucesso em sua carreira.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="load load-videos center" id="loadVideo"></div>
            </div>
            <div class="section-row mb-3 videos-layout hide">
                <div class="column-60">
                    <div class="card video-maior">
                        <div class="head-video">
                            <div class="flex">
                                <span class="tag h24"></span>
                                <div class="titulo"></div>
                            </div>
                            <div class="data" id="dataVideo"></div>
                        </div>
                        <iframe class="video-destaque" src="" title="" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                    </div>
                </div>
                <div class="column-40">
                    <div class="card videos-vert">
                    </div>
                </div>
            </div>
            <section class="filtros hide mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input type="text" name="pesquisa_livre" id="pesquisaLivreCards" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Pesquise pelo título do video</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <section class="videos-list-flex list-flex hide">
            </section>
            <div class="card hide" id="emptyVideo">
                <div class="empty">
                    <?php require_once("./assets/img/empty_search.svg"); ?>
                    <p>Nenhum video encontrado</p>
                </div>
            </div>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>