<?php

// definição das metatags de SEO
$meta_title = "Acessar - MaisDigital Workspace";
$meta_description = "Faça login para acessar os recursos que o MaisDigital Workspace tem para você!";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/login.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading_login.php"); ?>
<div class="container hide flex" data-route="login">
    <div class="center-content">
        <img class="logo" src="" alt="Logo">
        <div class="inner-box">
            <h3>Bem-vindo</h3>
            <p>Acesse com seu e-mail e senha</p>
            <form class="form" id="formLogin" action="./controller/login.php" method="post">
                <div class="fields gap-2">
                    <div class="input-content">
                        <input required type="email" name="email" id="email" class="input icon-left" placeholder="E-mail">
                        <span class="icon">
                            <span class="material-icons-round">person</span>
                        </span>
                    </div>
                    <div class="input-content" data-input="password" id="container-password">
                        <input required type="password" name="password" id="password" class="input icon-left with-icon" placeholder="Senha">
                        <span class="icon">
                            <span class="material-icons-round">vpn_key</span>
                        </span>
                        <span class="icon action password-off" data-input="password">
                            <span class="off material-icons-round">visibility_off</span>
                        </span>
                        <span class="icon action password-on hide" data-input="password">
                            <span class="on material-icons-round">visibility</span>
                        </span>
                    </div>
                    <input type="hidden" id="id_ec" name="id_ec">
                    <button class="botao delete">
                        <span class="text">Acessar</span>
                        <span class="load" id="load"></span>
                    </button>
                </div>

            </form>
        </div>
        <p class="">Esqueceu a senha? <a id="abrirModalRecuperarSenha" class="abre-modal" href="">Recuperar</a></p>
    </div>
    <?php require_once("model/body/modal_recupera_senha.php"); ?>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>