<?php

require_once("./controller/version.php");

// metatags gerais de configuração
$meta_locale = "pt_BR";
$meta_type = "website";
$meta_site_name = "VP | Empresas";

$server_name = $_SERVER["SERVER_NAME"];
$repo_name = explode("/",$_SERVER["PHP_SELF"])[1];

if($server_name == "localhost"){
    $base = $base = "https://".$server_name."/".$repo_name."/";
}else{
    $base = $base = "https://".$server_name."/";
}

?>

<!-- código fonte do head -->

<head>
    <!-- metatags de configuração -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <base href="<?= $base; ?>">

    <!-- favicon -->
    <link rel="icon" id="favicon" type="image/png" href="">
    <link rel="manifest" href="manifest.json">
    <meta name="msapplication-TileColor" content="#262626">
    <meta name="theme-color" content="#262626">

    <!-- título da página -->
    <title><?= $meta_title; ?></title>

    <!-- metatags de SEO -->
    <meta name="robots" content="<?= $meta_robots; ?>">
    <meta name="description" content="<?= $meta_description; ?>">
    <link rel="canonical" href="<?= $meta_canonical; ?>">

    <!-- metatags de SEO do Facebook -->
    <meta property="og:locale" content="<?= $meta_locale; ?>">
    <meta property="og:type" content="<?= $meta_type; ?>">
    <meta property="og:title" content="<?= $meta_title; ?>">
    <meta property="og:description" content="<?= $meta_description; ?>">
    <meta property="og:url" content="<?= $meta_canonical; ?>">
    <meta property="og:site_name" content="<?= $meta_site_name; ?>">
    <meta property="og:image" content="<?= $meta_feature_image; ?>">

    <!-- CDN Google Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Round" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@48,400,1,0" />

    <!-- CDN Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.3/font/bootstrap-icons.css">

    <!-- CDN Date range picker -->
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <!-- CDN Nice select -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-nice-select/1.1.0/css/nice-select.css" integrity="sha512-uHuCigcmv3ByTqBQQEwngXWk7E/NaPYP+CFglpkXPnRQbSubJmEENgh+itRDYbWV0fUZmUz7fD/+JDdeQFD5+A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

    <!-- folha de estilo global -->
    <link rel="stylesheet" href="src/styles/style.css?v=<?= $version; ?>">

</head>

<body>

    <noscript>
        <?php require_once("model/body/modal_noscript.php"); ?>
    </noscript>