<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Opções - Workspace Mais Digital";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/opcoes.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="opcoes" data-route="opcoes">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main">
        <div class="inner-container">
            <h3 class="title">Opções</h3>
            <section class="opcoes">
                <div class="card card-blog mb-5">
                    <form class="form" id="formLinkBlog">
                        <p class="titulo mb-0">Blog Mais Digital</p>
                        <p class="mb-3">O link do blog aparecerá para todos os usuários do workspace.</p>
                        <div class="fields">
                            <div class="row cols2">
                                <div class="input-content">
                                    <input required type="text" name="link" id="field_link_blog" class="input">
                                    <label for="field_link_blog">Link</label>
                                </div>
                            </div>
                        </div>
                        <div class="row-botao sticky">
                            <button disabled type="submit" class="botao primary botao-submit auto-width" id="btnAtualizaLinkBlog">
                                <span class="text">Atualizar link</span>
                                <span class="load" id="loadBlog"></span>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card">
                    <form class="form" id="formBrand">
                        <div class="titulo mb-0">Personalização</div>
                        <p class="mb-5">Personalize a aparência do workspace com as cores e a logo da sua empresa</p>
                        <div class="load load-usuarios mt-3 mb-3" id="loadUsuarios"></div>
                        <div class="fields hide">
                            <div class="row cols2">
                                <div class="input-content">
                                    <input required type="text" name="cor_primaria" id="field_cor_primaria_dados" class="input field-hexa mask-hexa">
                                    <label for="field_cor_primaria_dados">Cor primária</label>
                                    <div class="color-preview"></div>
                                </div>
                                <div class="input-content">
                                    <input required type="text" name="cor_secundaria" id="field_cor_secundaria_dados" class="input field-hexa mask-hexa">
                                    <label for="field_cor_secundaria_dados">Cor secundária</label>
                                    <div class="color-preview"></div>
                                </div>
                            </div>
                            <div class="row cols2">
                                <div class="upload-content">
                                    <p class="mb-1">Logomarca</p>
                                    <div class="flex column flex-upload">
                                        <label for="field_logo_dados" class="label-upload botao">
                                            <input hidden type="file" name="logo" id="field_logo_dados" accept="image/png">
                                            <div class="icon"><span class="material-icons-round">upload</span></div>
                                            <div class="text">Selecionar arquivo</div>
                                        </label>
                                        <div class="logo-preview">
                                            <div class="flex gap-sm">
                                                <div class="img">
                                                    <img src="" alt="Logomarca">
                                                </div>
                                                <div class="path"></div>
                                            </div>
                                            <div class="botao icone delete red small">
                                                <div class="icon">
                                                    <span class="material-icons-round">delete</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="upload-content">
                                    <p class="mb-1">Ícone</p>
                                    <div class="flex column flex-upload">
                                        <label for="field_icone_dados" class="label-upload botao">
                                            <input hidden type="file" name="icone" id="field_icone_dados" accept="image/png">
                                            <div class="icon"><span class="material-icons-round">upload</span></div>
                                            <div class="text">Selecionar arquivo</div>
                                        </label>
                                        <div class="logo-preview">
                                            <div class="flex gap-sm">
                                                <div class="img">
                                                    <img src="" alt="Logomarca">
                                                </div>
                                                <div class="path"></div>
                                            </div>
                                            <div class="botao icone delete red small">
                                                <div class="icon">
                                                    <span class="material-icons-round">delete</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card analise flex small border">
                                <div class="icone">
                                    <span class="material-icons-round">info</span>
                                </div>
                                <div class="conteudo">
                                    <p class="descricao">As cores devem estar no formato hexadecimal. A logomarca e o ícone devem estar no formato PNG e ter menos de 2MB.</p>
                                </div>
                            </div>
                        </div>
                        <div class="row-botao sticky">
                            <div class="btns gap-small">
                                <button disabled type="submit" class="botao primary botao-submit auto-width" id="btnAtualizaBrand">
                                    <span class="text">Atualizar dados</span>
                                    <span class="load" id="loadSubmitBrand"></span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- <div class="card">
                    <form class="form" id="formBrand">
                        <div class="titulo mb-0">Personalização</div>
                        <p class="mb-5">Personalize a aparência do workspace com as cores e a logo da sua empresa</p>
                        <div class="load load-usuarios mt-3 mb-3" id="loadUsuarios"></div>
                        <div class="fields hide">
                            <div class="row cols2">
                                <div class="input-content">
                                    <input required type="text" name="cor_primaria" id="field_cor_primaria_dados" class="input field-hexa mask-hexa">
                                    <label for="field_cor_primaria_dados">Cor primária</label>
                                    <div class="color-preview"></div>
                                </div>
                                <div class="input-content">
                                    <input required type="text" name="cor_secundaria" id="field_cor_secundaria_dados" class="input field-hexa mask-hexa">
                                    <label for="field_cor_secundaria_dados">Cor secundária</label>
                                    <div class="color-preview"></div>
                                </div>
                            </div>
                            <div class="row cols2">
                                <div class="upload-content">
                                    <p class="mb-1">Logomarca</p>
                                    <div class="flex column flex-upload">
                                        <label for="field_logo_dados" class="label-upload botao">
                                            <input hidden type="file" name="logo" id="field_logo_dados" accept="image/png">
                                            <div class="icon"><span class="material-icons-round">upload</span></div>
                                            <div class="text">Selecionar arquivo</div>
                                        </label>
                                        <div class="logo-preview">
                                            <div class="flex gap-sm">
                                                <div class="img">
                                                    <img src="" alt="Logomarca">
                                                </div>
                                                <div class="path"></div>
                                            </div>
                                            <div class="botao icone delete red small">
                                                <div class="icon">
                                                    <span class="material-icons-round">delete</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="upload-content">
                                    <p class="mb-1">Ícone</p>
                                    <div class="flex column flex-upload">
                                        <label for="field_icone_dados" class="label-upload botao">
                                            <input hidden type="file" name="icone" id="field_icone_dados" accept="image/png">
                                            <div class="icon"><span class="material-icons-round">upload</span></div>
                                            <div class="text">Selecionar arquivo</div>
                                        </label>
                                        <div class="logo-preview">
                                            <div class="flex gap-sm">
                                                <div class="img">
                                                    <img src="" alt="Logomarca">
                                                </div>
                                                <div class="path"></div>
                                            </div>
                                            <div class="botao icone delete red small">
                                                <div class="icon">
                                                    <span class="material-icons-round">delete</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card analise flex small border">
                                <div class="icone">
                                    <span class="material-icons-round">info</span>
                                </div>
                                <div class="conteudo">
                                    <p class="descricao">As cores devem estar no formato hexadecimal. A logomarca e o ícone devem estar no formato PNG e ter menos de 2MB.</p>
                                </div>
                            </div>
                        </div>
                        <div class="row-botao sticky">
                            <div class="btns gap-small">
                                <button disabled type="submit" class="botao primary botao-submit auto-width" id="btnAtualizaBrand">
                                    <span class="text">Atualizar dados</span>
                                    <span class="load" id="loadSubmitBrand"></span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div> -->
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>