<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Parceiros BB - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/parceiros.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="parceiros-bb" data-route="parceiros-bb">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main parceiros">
        <div class="inner-container">
            <div class="banner mb-3 banner-parceiro">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Parceiros BB</h3>
                        <p>Saiba como os parceiros do Banco do Brasil podem te ajudar em diversas áreas.</p>
                    </div>
                </div>
            </div>
            <div class="section-row">
                <div class="column-60">
                    <div class="card">
                        <section class="filtros mb-3">
                            <div class="flex">
                                <form class="form" id="formPesquisaLivre">
                                    <div class="fields">
                                        <div class="row">
                                            <div class="input-content">
                                                <input type="text" name="pesquisa_livre" id="pesquisaLivreParceiro" data-key="live" class="input icon-right">
                                                <label for="pesquisaLivreParceiro">Pesquise pelo nome do parceiro</label>
                                                <div class="icon right">
                                                    <span class="material-icons-round">search</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </section>
                        <div class="load load-parceiros center" id="loadParceiros"></div>
                        <div class="hide" id="emptyParceiro">
                            <div class="empty">
                                <?php require("./assets/img/empty_search.svg"); ?>
                                <p>Nenhum parceiro encontrado</p>
                            </div>
                        </div>
                        <ul class="parceiros-list lista hide">
                        </ul>
                    </div>

                </div>
                <div class="column-40">
                    <div class="card">
                        <div class="conteudo">
                            <div class="titulo mb-2">Portais</div>
                            <section class="filtros mb-3">
                                <div class="flex">
                                    <form class="form" id="formPesquisaLivrePortais">
                                        <div class="fields">
                                            <div class="row">
                                                <div class="input-content">
                                                    <input type="text" name="pesquisa_livre" id="pesquisaLivrePortais" data-key="live" class="input icon-right">
                                                    <label for="pesquisaLivrePortais">Pesquise pelo nome do portal</label>
                                                    <div class="icon right">
                                                        <span class="material-icons-round">search</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </section>
                            <div class="load load-portais center" id="loadPortais"></div>
                            <div class="hide" id="emptyPortais">
                                <div class="empty">
                                    <?php require("./assets/img/empty_search.svg"); ?>
                                    <p>Nenhum portal encontrado</p>
                                </div>
                            </div>
                            <ul class="portais-list lista hide">
                            </ul>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>