<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "FAQ - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/faq.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="perguntas-frequentes" data-route="perguntas-frequentes">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main perguntas-frequentes">
        <div class="inner-container">
            <div class="banner mb-5 banner-usuarios">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Perguntas Frequentes</h3>
                        <p>Confira aqui as dúvidas mais frequentes sobre os produtos e serviços ofertados pelo Coban Mais Digital.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="load load-faq center" id="loadFAQ"></div>
            </div>
            <section class="categorias mb-3">
                <div class="categoria ativo">
                    <div class="circle"></div>
                    Empréstimo pessoal
                </div>
                <div class="categoria">
                    <div class="circle"></div>
                    Parceiro
                </div>
                <div class="categoria">
                    <div class="circle"></div>
                    Dúvidas gerais
                </div>
            </section>
            <div class="card hide">
                <div class="load load-perguntas center" id="loadPerguntas"></div>
            </div>
            <section class="perguntas"></section>
            <div class="card hide" id="emptyFAQ">
                <div class="empty">
                    <?php require_once("./assets/img/empty_search.svg"); ?>
                    <p>Nenhuma pergunta encontrada</p>
                </div>
            </div>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>