<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Políticas e Termos - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/termos.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="termos" data-route="termos-politicas">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main termos">
        <div class="inner-container">
            <div class="banner mb-5 banner-politica">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Políticas e Termos</h3>
                        <p>Leia nossos termos e políticas para entender as regras e orientações sobre o uso dos produtos e serviços do Coban Mais Digital.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="load load-termo center" id="loadTermo"></div>
            </div>
            <section class="categorias mb-3"></section>
            <div class="card hide">
                <div class="load load-politica center" id="loadPolitica"></div>
            </div>
            <div class="card hide termo-content">
                <h3 class="mb-3 termo-title"></h3>
                <div class="mb-3 termo-date hide"><b>Data de atualização:</b> <span></span></div>
                <div class="termo-text"></div>
                <div class="row sticky anexo hide">
                    <a class="botao primary auto-width" target="_blank">
                        <div class="icon">
                            <span class="material-symbols-rounded">download</span>
                        </div>
                        <div class="text">Baixar arquivo</div>
                    </a>
                </div>
            </div>
            <div class="card hide" id="emptyTermo">
                <div class="empty">
                    <?php require_once("./assets/img/empty_search.svg"); ?>
                    <p>Nenhuma política ou termo encontrado</p>
                </div>
            </div>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>