$(function(){

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoArte");
    verificaInputsRequired("formNovoArte");
    validationForm("formDadosArte");
    verificaInputsRequired("formDadosArte");

    var toolbarOptions = [
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        ['bold', 'italic', 'underline', 'strike'],
        ['link'],
        [{ 'list': 'ordered'},{'list':'bullet'}, { 'align': []}],
        ['clean']
    ];

    var options = {
        placeholder: 'Descrição do vídeo...',
        theme: 'snow',
        modules: {
            toolbar: toolbarOptions
        }
    };

    var quill = new Quill(".editor", options);

    var quillDados = new Quill(".editor-dados", options);


    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarArte").click(function () {
        abreModal("modalNovoArte");
    });

    $("#fechaModalNovoArte").click(() => {
        $("#modalNovoArte").hide();
    });

    $("body").on("keyup click",".editor .ql-editor", function(){
        $("#callback_arte").val($(this).html());
        if($("#callback_arte").val() == "<p><br></p>"){
            $("#btnCadastraArte").attr("disabled", true);
        }else{
            $("#btnCadastraArte").attr("disabled", false);
        }
    });

    $("body").on("keyup click",".editor-dados .ql-editor", function(){
        $("#callback_arte_dados").val($(this).html());
        if($("#callback_arte_dados").val() == "<p><br></p>"){
            $("#btnAtualizaArte").attr("disabled", true);
        }else{
            $("#btnAtualizaArte").attr("disabled", false);
        }
    });

    function sendFetchDados() {
        $("#btnCadastraArte .load").show();
        $("#btnCadastraArte .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoArte").submit(function (e) {
        e.preventDefault();

        if($("#field_titulo").val().length === 0){
            $("#field_titulo").val($("#callback_arte").val().replace(/<[^>]*>/g," ").replace(/\s{2,}/g," ").trim().split(".")[0]).addClass("input-active");
        }

        sendFetchDados("./controller/cadastra_arte.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraArte .text").show();
                $("#btnCadastraArte .load").hide();
                return;
            }
            
            $("#btnCadastraArte .text").show();
            $("#btnCadastraArte .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosArte .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaArte").on("click",".abre-detalhes", function () {

        abreModal("modalDadosArte");
        const idEstabelecimento = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_arte.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            console.log(dados);

            $("#field_titulo_dados").val(dados.titulo).addClass("input-active");
            $("#modalDadosArte .ql-editor").html(dados.descricao);
            $("#modalDadosArte #callback_arte_dados").val(dados.descricao);
            $("#field_link_dados").val(dados.link).addClass("input-active");

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";

            $("#field_hidden_status").val(dados.status);
            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");

            $("#btnAtualizaArte").data("id", dados.id);
            
            $("#modalDadosArte .load-detalhes").hide();
            $("#formDadosArte").removeClass("hide");

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosArte").click(() => {
        closeModalArte();
    });

    function closeModalArte(){
        $("#modalDadosArte .load-detalhes").show();
        $("#modalDadosArte").hide();
        $("#formDadosArte").addClass("hide");
        $("#btnAtualizaArte").attr("disabled", true);
    }

    function sendFetchAtualizaDados() {
        $("#btnAtualizaArte .load").show();
        $("#btnAtualizaArte .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosArte").submit(function (e) {
        e.preventDefault();

        const idArte = $("#btnAtualizaArte").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_arte.php?id="+idArte, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaArte .text").show();
                $("#btnAtualizaArte .load").hide();
                return;
            }
            
            $("#btnAtualizaArte .text").show();
            $("#btnAtualizaArte .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            closeModalArte();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#listaArte").on("click",".exclui-arte", function () {
        const idArte = $(this).closest("tr").data("id");
        $("#btnExcluiArte").data("id",idArte);
        abreModal("modalExcluiArte");
    });

    $("#btnFechaModalExcluiArte").click(()=>{
        $("#modalExcluiArte").hide();
    });

    function sendFetchExcluiArte() {
        $("#btnExcluiArte .load").show();
        $("#btnExcluiArte .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#btnExcluiArte").click(function (e) {
        e.preventDefault();

        const idArte = $(this).data("id");

        sendFetchExcluiArte("./controller/deleta_arte.php?id="+idArte).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnExcluiArte .text").show();
                $("#btnExcluiArte .load").hide();
                return;
            }
            
            $("#btnExcluiArte .text").show();
            $("#btnExcluiArte .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
        $("#btnAtualizaArte").attr("disabled", false);
    });

});