$(function () {

    recuperaMenus();
    recuperaDados();

    //ações de abrir e fechar o modal de pesquisa de bancos
    $("#abreModalPesquisaBancos").click(() => {
        abreModal("modalPesquisaBancos");
        $("#field_pesquisa_banco").focus();
    });

    $("#fechaModalPesquisaBanco").click(() => {
        $("#modalPesquisaBancos").hide();
    });


    // preencher a lista de bancos vindos da API
    function sendFetchBancos() {
        $("#loadBancos").show();
        return fetch.apply(this, arguments);
    }

    sendFetchBancos("https://brasilapi.com.br/api/banks/v1").then((resp) => resp.json()).then(function (bancos) {

        var li = "";

        bancos.forEach(banco => {
            if (banco.code === null) return;

            li += "<li data-ordem='" + banco.code + "'>";
            li += "<p class='code'>" + banco.code + "</p>";
            li += "<p class='name'>" + banco.name + "</p>";
            li += "</li>";
        });

        $(".linhas").append(li);
        $("li.center").hide();

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });


    // filtro de bancos
    $("#field_pesquisa_banco").on("input", function () {
        $(".linhas li").removeClass("result-on");

        if ($(this).val() != "") {
            $(".linhas li").hide();
            $(".linhas li:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
            $("li.center").hide();
        } else {
            $(".linhas li").show();
            $("li.center").hide();
        }
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $(".error-bank").show();
        } else {
            $(".error-bank").hide();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

    // preenchendo campo com banco escolhido
    $("body").on("click", ".linhas li", function () {
        const code = $(this).children(".code").text();
        const name = $(this).children(".name").text();
        $("#field_banco").val(code + " - " + name);
        $("#field_pesquisa_banco").val("");
        $(".linhas li").show();
        $("#modalPesquisaBancos").hide();
        $("li.center").hide();
    });


    // atualizar dados do parceiro
    function sendFetchDados() {
        $("#loadSubmit").show();
        $("#btnAtualizaDados .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosEmpresa").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/atualiza_dados_usuario.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
            }
            
            $("#btnAtualizaDados .text").show();
            $("#loadSubmit").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    validationForm("formDadosEmpresa");


});