$(function () {

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoEstabelecimento");
    verificaInputsRequired("formNovoEstabelecimento");
    validationForm("formDadosEstabelecimento");
    verificaInputsRequired("formDadosEstabelecimento");

    const uniqueKey = Date.now().toString() + Math.random().toString().substr(2, 6);

    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarEstabelecimento").click(function () {
        abreModal("modalNovoEstabelecimento");
    });

    $("#fechaModalNovoEtabelecimento").click(() => {
        $("#modalNovoEstabelecimento").hide();
    });

    $("#pesquisaLivre, #pesquisaCNPJ, #selectUF").on("input change", function () {
        $("#listaEstabelecimentos tr").removeClass("result-on");

        if ($(this).val() != "") {
            $("#listaEstabelecimentos tr").hide();
            $("#listaEstabelecimentos tr:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $("#listaEstabelecimentos tr").show();
        }

        if($(this).val() === "Todos") {
            $("#listaEstabelecimentos tr").show();
            $(".empty-search").addClass("hide");
            $("#tableEstabelecimentos").show();
        }
    });

    $("#selectUF").on("change", function () {
        $("#pesquisaLivre, #pesquisaCNPJ").val("").removeClass("input-active");
    });

    $("#pesquisaLivre").on("input", function () {
        $("#selectUF").next().parent().find(".current").text("Todos");
        $("#pesquisaCNPJ").val("").removeClass("input-active");
    });

    $("#pesquisaCNPJ").on("input", function () {
        $("#selectUF").next().parent().find(".current").text("Todos");
        $("#pesquisaLivre").val("").removeClass("input-active");
    });

    $("#resetaFiltros").on("click", function(e){
        e.preventDefault();
        $("#pesquisaLivre, #pesquisaCNPJ").val("").removeClass("input-active");
        $("#selectUF").next().parent().find(".current").text("Todos");
        $("#listaEstabelecimentos tr").show();
        $(".empty-search").addClass("hide");
        $("#tableEstabelecimentos").show();
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $(".empty-search").removeClass("hide");
            $("#tableEstabelecimentos").hide();
        } else {
            $(".empty-search").addClass("hide");
            $("#tableEstabelecimentos").show();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

    $("#field_nome_fantasia").on("input", function(){
        if($(this).val().length === 0){
            $("#field_chave").val("").removeClass("input-active");
        }else{
            $("#field_chave").val($(this).val().normalize('NFD').replace(/[\u0300-\u036f]/g, "").replaceAll(" ","")).addClass("input-active");
        }
    });

    document.getElementById("field_chave").addEventListener("keypress", function(e){
        if(!checkChar(e)){
            e.preventDefault();
        }
    });

    function checkChar(e) {
        const char = String.fromCharCode(e.keyCode);
        const pattern = '[a-zA-Z0-9]';
        if(char.match(pattern)){
            return true;
        }
    }

    function sendFetchDados() {
        $("#btnCadastraEstabelecimento .load").show();
        $("#btnCadastraEstabelecimento .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoEstabelecimento").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_estabelecimento.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraEstabelecimento .text").show();
                $("#btnCadastraEstabelecimento .load").hide();
                return;
            }
            
            $("#btnCadastraEstabelecimento .text").show();
            $("#btnCadastraEstabelecimento .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosEstabelecimento .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaEstabelecimentos").on("click",".abre-detalhes", function () {

        abreModal("modalDadosEstabelecimento");
        const idEstabelecimento = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_estabelecimento.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            console.log(dados);

            $("#field_cnpj_dados").val(dados.cnpj).addClass("input-active");
            $("#field_razao_social_dados").val(dados.razao_social).addClass("input-active");
            $("#field_nome_fantasia_dados").val(dados.nome_fantasia).addClass("input-active");
            $("#field_cep_dados").val(dados.cep).addClass("input-active");
            $("#field_logradouro_dados").val(dados.logradouro).addClass("input-active");
            $("#field_numero_dados").val(dados.numero).addClass("input-active");
            $("#field_complemento_dados").val(dados.complemento).addClass("input-active");
            $("#field_bairro_dados").val(dados.bairro).addClass("input-active");
            $("#field_cidade_dados").val(dados.cidade).addClass("input-active");
            $("#field_uf_dados").val(dados.uf).addClass("input-active");
            $("#field_site_dados").val(dados.site).addClass("input-active");
            $("#field_email_dados").val(dados.email).addClass("input-active");
            $("#field_chave_dados").val(dados.chave).addClass("input-active");
            $("#numeroUsuarios").text(dados.qtd_usuarios);

            $("#field_cor_primaria_dados").val(dados.cor_primaria).addClass("input-active");
            $("#field_cor_primaria_dados").next().next().css("background",dados.cor_primaria);
            $("#field_cor_secundaria_dados").val(dados.cor_secundaria).addClass("input-active");
            $("#field_cor_secundaria_dados").next().next().css("background",dados.cor_secundaria);

            if(dados.logo.split("/")[4].length >= 8){
                let splitNameLogo = dados.logo.split("/")[4].split(".");
                var fileNameLogo = splitNameLogo[0].substring(0,8) + "... ." + splitNameLogo[1];
            }

            $("#field_logo_dados").closest(".label-upload").next().parent().find(".path").text(fileNameLogo);
            $("#field_logo_dados").closest(".label-upload").next().parent().find("img").attr("src",dados.logo + "?v=" + uniqueKey);
            $("#field_logo_dados").closest(".label-upload").next().show().css("display", "flex");

            if(dados.icone.split("/")[4].length >= 8){
                let splitNameIcone = dados.icone.split("/")[4].split(".");
                var fileNameIcone = splitNameIcone[0].substring(0,8) + "... ." + splitNameIcone[1];
            }

            $("#field_icone_dados").closest(".label-upload").next().parent().find(".path").text(fileNameIcone);
            $("#field_icone_dados").closest(".label-upload").next().parent().find("img").attr("src",dados.icone + "?v=" + uniqueKey);
            $("#field_icone_dados").closest(".label-upload").next().show().css("display", "flex");

            const data = new Date(dados.data_cadastro);
            $("#field_data_cadastro_dados").val(data.toLocaleDateString()).addClass("input-active");

            let status;
            dados.status === "0" ? status = "inativo" : status = "ativo";

            $("#tagStatus").text("Estabelecimento "+status).addClass(status).show().css("display", "inline-flex");

            verificarInputsPreenchidos("formDadosEstabelecimento");

            $(".altera-status").data("id", dados.id);
            $(".enviar-email").data("id", dados.id);
            $("#btnAtualizaEstabelecimento").data("id", dados.id);
            
            $("#modalDadosEstabelecimento .load-detalhes").hide();
            $("#formDadosEstabelecimento").show();
            $("#tagNumeroUsuarios").show().css("display", "inline-flex");

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
            console.log(error);
        });
    });

    $("#fechaModalDadosEtabelecimento").click(() => {
        closeModalEstabelecimento();
    });

    function closeModalEstabelecimento(){
        $("#tagNumeroUsuarios, #tagStatus, #modalDadosEstabelecimento, #formDadosEstabelecimento").hide();
        $("#modalDadosEstabelecimento .load-detalhes").show();
        $("#modalDadosEstabelecimento .botao-submit").attr("disabled", true);
        $("#tagStatus").removeClass("ativo inativo");
    }

    $("#abreOpcoes").on("click", function () {
        $("#optionsEstabelecimento").show();
    });

    // fecha options
    $("body").click(function (e) {
        var condicao = $(e.target).is(".options *") || $(e.target).is(".options") || $(e.target).is(".abre-options *") || $(e.target).is(".abre-options");

        if (!condicao) {
            $(".options").hide();
        }
    });

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
    });

    function sendFetchStatus() {
        $("#modalAlteraStatus .load-status").show();
        return fetch.apply(this, arguments);
    }

    $(".altera-status").on("click", function(){
        abreModal("modalAlteraStatus");
        const idEstabelecimento = $(this).data("id");

        sendFetchStatus("./controller/consulta_estabelecimento.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#nomeEstabelecimento").text(dados.nome_fantasia);
            $("#field_hidden_status").val(dados.status);
            $("#field_hidden_id").val(dados.id);

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";
            $("#statusEstabelecimento").text(status).addClass(status.toLowerCase());

            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");
            
            $("#modalAlteraStatus .load-status").hide();
            $("#formAlteraStatus").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });

    });

    function sendFetchEmail() {
        $("#modalEnviaEmail .load-email").show();
        return fetch.apply(this, arguments);
    }

    $(".enviar-email").on("click", function(){
        abreModal("modalEnviaEmail");
        const idEstabelecimento = $(this).data("id");

        sendFetchEmail("./controller/consulta_estabelecimento.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#nomeEC").text(dados.nome_fantasia);
            $("#emailEC").text(dados.email);
            $("#hidden_email").val(dados.email);
            $("#btnAbrirEmail").attr("href",`mailto:${dados.email}`);
            
            $("#modalEnviaEmail .load-email").hide();
            $("#formEnviaEmail").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });

    });

    // copia o link do parceiro
    jQuery('#btnCopiarEmail').click(function () {
        jQuery('#hidden_email').select();
        try {
            var ok = document.execCommand('copy');
            if (ok) {

                jQuery("#btnCopiarEmail .text").text("E-mail copiado");
                jQuery("#btnCopiarEmail").addClass("sucesso");

                setTimeout(function () {

                    jQuery("#btnCopiarEmail .text").text("Copiar e-mail");
                    jQuery("#btnCopiarEmail").removeClass("sucesso");

                }, 3000);

            }
        } catch (e) {
            alert(e);
        }
    });

    $("#fechaModalAlteraStatus").click(() => {
        closeModalAlteraStatus();
    });

    $("#fechaModalEnviaEmail").click(() => {
        closeModalEnviaEmail();
    });

    function closeModalAlteraStatus(){
        $("#modalAlteraStatus, #formAlteraStatus").hide();
        $("#modalAlteraStatus .load-status").show();
        $("#statusEstabelecimento").removeClass("ativo inativo");
    }

    function closeModalEnviaEmail(){
        $("#modalEnviaEmail, #formEnviaEmail").hide();
        $("#modalEnviaEmail .load-email").show();
    }

    function sendFetchSalvaStatus() {
        $("#btnAlteraStatus .load").show();
        $("#btnAlteraStatus .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formAlteraStatus").submit(function (e) {
        e.preventDefault();

        sendFetchSalvaStatus("./controller/altera_status_estabelecimento.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAlteraStatus .text").show();
                $("#btnAlteraStatus .load").hide();
                return;
            }
            
            $("#btnAlteraStatus .text").show();
            $("#btnAlteraStatus .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            closeModalEstabelecimento();
            closeModalAlteraStatus();
            recuperaDados();
            $(".modal").hide();

            console.log(data);

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
            console.log(error);
        });
    });

    $(".field-hexa").on("keyup", function(){
        $(this).next().next().css("background-color",$(this).val());
    });

    let fileInput = $(".label-upload input");

    fileInput.on("change", function({target}){


        let file = target.files[0];
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(file.type != "image/png") {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo no formato PNG");
                return;
            }

            if(fileSize > 3072) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 3 MB");
                return;
            }

            if(fileName.length >= 8){
                let splitName = fileName.split(".");
                fileName = splitName[0].substring(0,8) + "... ." + splitName[1];
            }

            $("#"+target.id).closest(".label-upload").next().parent().find(".path").text(fileName);
            $("#"+target.id).closest(".label-upload").next().parent().find("img").attr("src",URL.createObjectURL(file));
            $("#"+target.id).closest(".label-upload").next().show().css("display", "flex");

            verificarInputsObrigatorios("formNovoEstabelecimento");
        }
        
    });

    $(".delete").on("click", function(){
        $(this).closest(".flex-upload").parent().find("input").val("");
        $(this).closest(".logo-preview").hide();

        $("#btnCadastraEstabelecimento").attr("disabled", true);
    });

    sticky("#estabelecimentosTable");

    function sendFetchAtualizaDados() {
        $("#btnAtualizaEstabelecimento .load").show();
        $("#btnAtualizaEstabelecimento .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosEstabelecimento").submit(function (e) {
        e.preventDefault();

        const idEstabelecimento = $("#btnAtualizaEstabelecimento").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_estabelecimento.php?id="+idEstabelecimento, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaEstabelecimento .text").show();
                $("#btnAtualizaEstabelecimento .load").hide();
                return;
            }
            
            $("#btnAtualizaEstabelecimento .text").show();
            $("#btnAtualizaEstabelecimento .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});