$(function () {

    // ######################################### ACTIONS ######################################### //

    $(".select").niceSelect();

    $("body").on("click",".head-sanfona", function(){
        $(this).find(".icone").toggleClass("rotate");
        $(this).closest(".sanfona").find(".dados").slideToggle(240);
    });

    // mostra a senha
    $(".password-off").click(function(){
        $(this).addClass("hide");
        const id = $(this).data("input");
        $("#container-"+id+" .password-on").removeClass("hide");
        $("#"+id).attr("type","text");
    });
    
    // oculta a senha
    $(".password-on").click(function(){
        $(this).addClass("hide");
        const id = $(this).data("input");
        $("#container-"+id+" .password-off").removeClass("hide");
        $("#"+id).attr("type","password");
    });

    // oculta a mensagem
    $(document).click(function () {
        $(".msg").removeClass("on");
    });

    // gera o qr code
    $("#btnGera").click(() => {
        geraQRCode();
    });

    // baixa o qr code
    $('#btnDownload').click(() => {
        baixaQRCode();
    });

    // abre opções do usuário
    $(".profile").click(function () {
        $(".options-user").show();
    });

    // fecha opções do usuário
    $("body").click(function (e) {
        var condicao = $(e.target).is(".profile *");

        if (!condicao) {
            $(".options-user").hide();
        }
    });

    // fecha modal
    $("body").click(function (e) {
        // var condicao = $(e.target).is(".modal *") || $(e.target).is(".abre-modal") || $(e.target).is(".abre-modal *") || $(e.target).is(".no-close") || $(e.target).is(".abre-modal") || $(e.target).is(".ui-datepicker") || $(e.target).is(".ui-datepicker *") || $(e.target).is(".ui-datepicker-header") || $(e.target).is(".ui-datepicker-header *");

        var condicao = $(e.target).is(".modal") && !$(e.target).is(".no-close") || $(e.target).is(".modal .close");

        if (condicao) {
            $(".modal").hide();
        }
    });

    // copia o link do parceiro
    jQuery('.copiar').click(function () {
        jQuery('#link').select();
        try {
            var ok = document.execCommand('copy');
            if (ok) {

                jQuery(".copiar .text").text("Copiado");
                jQuery(".copiar .icon span").text("check");
                jQuery(".copiar").addClass("sucesso");

                setTimeout(function () {

                    jQuery(".copiar .text").text("Copiar");
                    jQuery(".copiar .icon span").text("copy");
                    jQuery(".copiar").removeClass("sucesso");

                }, 3000);

            }
        } catch (e) {
            alert(e);
        }
    });

    // fecha o card de status enquanto a sessão estiver ativa
    $("#closeStatus").click(function () {
        sessionStorage.setItem("statusCard", "false");
        $(".progresso").hide();
    });

    // define as máscaras de formulário
    var SPMaskBehavior = function (val) {
            return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        },
        spOptions = {
            onKeyPress: function (val, e, field, options) {
                field.mask(SPMaskBehavior.apply({}, arguments), options);
            }
        };

    $('.mask-phone').mask(SPMaskBehavior, spOptions);
    $('.mask-date').mask('00/00/0000');
    $('.mask-cep').mask('00000-000');
    $('.mask-token').mask('000000');
    $('.mask-cpf').mask('000.000.000-00');
    $('.mask-cnpj').mask('00.000.000/0000-00');
    $('.mask-hexa').mask('hHHHHHH', {
        translation: {
          'H': {
            pattern: /[0-9A-Fa-f]/
          },
          'h': {
            pattern: /[#]/,
            fallback: '#'
          }
        }
    });
    $('.mask-conta').mask('#00-0', {reverse: true});

    $("#toggleSidebar").on("click",function(){
        const content = $(".main");
        const sidebar = $(".sidebar");
        const icone = $("#toggleSidebar span");

        content.toggleClass("sidebar-open");
        sidebar.toggleClass("sidebar-open");

        if(content.hasClass("sidebar-open")){
            icone.text("close");
        }else{
            icone.text("menu");
        }
    });

    $(".backdrop-sidebar").on("click", function(){
        const content = $(".main");
        const sidebar = $(".sidebar");
        const icone = $("#toggleSidebar span");

        content.toggleClass("sidebar-open");
        sidebar.toggleClass("sidebar-open");

        if(content.hasClass("sidebar-open")){
            icone.text("close");
        }else{
            icone.text("menu");
        }
    });

    $("#fechaModalImagem").on("click", function(){
        $(".lightbox").hide();
    });

    $("body").on("click",".body-recado .imagem img", function(){
        let img = $(this).data("img");
        $(".lightbox .imagem").attr("src", img);
        abreModal("modalImagem");
    });

});

// ######################################### FUNCTIONS ######################################### //

// pega o id do video do youtube
function getYouTubeId(url) {
    var regex = /[?&]([^=#]+)=([^&#]*)|youtu.be\/([^\/?&#]+)/g;
    var match;
    while (match = regex.exec(url)) {
      if (match[1] === 'v' || match[3]) {
        return match[2] || match[3];
      }
    }
    return null;
  }

// mostra o preview da imagem selecionada
function previewImageUpload(fileInput) {

    const input = document.querySelector(fileInput);

    let file = input.files[0];

    if(file.size > 3145728) {
        $(".msg").addClass("on");
        $(".msg .text").text("Escolha uma imagem menor que 3MB");
        return false;
    }

    if(!file) return false;

    console.log(input.files);
    return URL.createObjectURL(file);
}

// define o menu ativo por página
function ativaMenu() {
    const container = $('.container').data('menu');
    $('.menu-items li').each(function () {
        $(this)
            .find('a#' + container)
            .addClass('active');
    });
}

function sendFetch() {
    $(".loading").show();
    $(".container").addClass("hide");
    return fetch.apply(this, arguments);
}

function sendFetchPerguntas() {
    $("#loadPerguntas").closest(".card").removeClass("hide");
    $("#loadPerguntas").show();
    return fetch.apply(this, arguments);
}

function sendFetchEC() {
    $("#loadEstabelecimentos").show();
    return fetch.apply(this, arguments);
}

function sendFetchTermo() {
    $("#loadPolitica").closest(".card").removeClass("hide");
    $("#loadPolitica").show();
    return fetch.apply(this, arguments);
}

// monta os menus
const recuperaMenus = () => {
    sendFetch("./controller/menus.php").then((resp) => resp.json()).then(function (menus) {

        if (menus.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(menus.message);
            return;
        }

        var li = "";

        menus.list.forEach(menu => {

            var em_breve = "";
            var menu_link = "";

            if (menu.em_breve == "1") {
                em_breve = '<span class="tag">Em breve</span>';
            }

            if (menu.link != "") {
                menu_link = 'href="' + menu.link + '"';
            }

            if (menu.tipo == "divider") {
                li += '<li class="divider"></li>';
            } else {
                li += '<li class="menu-item">';
                li += '<a id="' + menu.id_html + '"' + ' ' + menu_link + '">';
                li += '<div class="icone">' + menu.icone + '</div>';
                li += '<div class="texto">' + menu.texto + ' ' + em_breve + '</div>';
                li += '</a>';
                li += '</li>';
            }
        });

        $(".menu-items").html(li);
        $("#loadMenus").hide();
        ativaMenu();

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta os estabelecimentos
const recuperaEstabelecimentos = (select = null) => {

    $("#loadInputEC").show();
    $("#field_estabelecimento").next().parent().find(".current").text("");

    sendFetchEC("./controller/recupera_estabelecimentos.php").then((resp) => resp.json()).then(function (estabelecimentos) {

        if (estabelecimentos.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(estabelecimentos.message);

            $("#loadEstabelecimentos").hide();
            $("#emptyEstabelecimentos").removeClass("hide");

            if(select != null){
                $("#field_estabelecimento").closest(".input-content").hide();
                $("#field_estabelecimento").html(`<option selected value="1">1</option>`);
    
                $("#loadInputEC").hide();
    
                $("#field_perfil option:first").remove();
                $("#field_perfil").next().parent().find(".list li:first").remove();
                $("#field_perfil").next().parent().find(".list li:last").addClass("selected");
                $("#field_perfil").next().parent().find(".current").text($("#field_perfil").next().parent().find(".list li:last").text());
            }

            return;
        }

        const mapaEstados = {
            "AC": "Acre",
            "AL": "Alagoas",
            "AP": "Amapá",
            "AM": "Amazonas",
            "BA": "Bahia",
            "CE": "Ceará",
            "DF": "Distrito Federal",
            "ES": "Espírito Santo",
            "GO": "Goiás",
            "MA": "Maranhão",
            "MT": "Mato Grosso",
            "MS": "Mato Grosso do Sul",
            "MG": "Minas Gerais",
            "PA": "Pará",
            "PB": "Paraíba",
            "PR": "Paraná",
            "PE": "Pernambuco",
            "PI": "Piauí",
            "RJ": "Rio de Janeiro",
            "RN": "Rio Grande do Norte",
            "RS": "Rio Grande do Sul",
            "RO": "Rondônia",
            "RR": "Roraima",
            "SC": "Santa Catarina",
            "SP": "São Paulo",
            "SE": "Sergipe",
            "TO": "Tocantins"
        }

        $("#loadEstabelecimentos").show();
        $(".estabelecimentos .numeroCadastrados").text(estabelecimentos.quantidade);

        var linha = "";
        var option = "";
        var item = "";
        var cont = 1;
        var primeiroEcAtivo = "";

        estabelecimentos.list.forEach(estabelecimento => {

            let ativo = "";

            if(estabelecimento.status === "0"){
                ativo = "Inativo";
            }else{
                ativo = "Ativo";

                if(select == "2" && estabelecimento.id != "1"){
                    option += `<option value="${estabelecimento.id}">${estabelecimento.nome_fantasia}</option>`;
                    item += `<li data-value="${estabelecimento.id}" class="option">${estabelecimento.nome_fantasia}</li>`;
                }

                if(select == "3" || select == "1" && estabelecimento.id == "1"){
                    option += `<option value="${estabelecimento.id}">${estabelecimento.nome_fantasia}</option>`;
                    item += `<li data-value="${estabelecimento.id}" class="option">${estabelecimento.nome_fantasia}</li>`;
                }
            }

            linha += `<tr data-id="${estabelecimento.id}">`;
                linha += `<td>${cont}</td>`;
                linha += `<td>${estabelecimento.nome_fantasia}</td>`;
                linha += `<td>${estabelecimento.cnpj}</td>`;
                linha += `<td>${mapaEstados[estabelecimento.uf]}</td>`;
                linha += `<td><span class="tag h24 ${ativo.toLowerCase()}">${ativo}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                    // linha += `<div class="icone-table abre-email"><span class="material-symbols-rounded">mail</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

            cont++;
        });

        if(select == "2"){
            primeiroEcAtivo = estabelecimentos.list.filter(estabelecimento => estabelecimento.status == 1 && estabelecimento.id != "1");
            if(primeiroEcAtivo.length === 0) return;
            $("#field_estabelecimento").next().parent().find(".current").text(primeiroEcAtivo[0].nome_fantasia);
        }

        if(select == "3" || select == "1"){
            primeiroEcAtivo = estabelecimentos.list.filter(estabelecimento => estabelecimento.status == 1 && estabelecimento.id == "1");
            if(primeiroEcAtivo.length === 0) return;
            $("#field_estabelecimento").next().parent().find(".current").text(primeiroEcAtivo[0].nome_fantasia);
        }

        if(select != null){
            $("#field_estabelecimento").html(option);
            $("#field_estabelecimento").next().parent().find(".list").html(item);
            $("#loadInputEC").hide();
        }

        $("#listaEstabelecimentos").html(linha);
        $("#loadEstabelecimentos").hide();
        $("#tableEstabelecimentos").removeClass("hide");
        $("#emptyEstabelecimentos").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta os recados
const recuperaRecados = (limit = null, all = null) => {

    let urlBase = "./controller/recupera_recados.php?";
    const params = new URLSearchParams();

    if(limit) params.append("limit", limit);
    if(all) params.append("all", all);

    let urlConsulta = urlBase + params.toString();

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (recados) {

        if($(".container").data("route") == "home" || $(".container").data("route") == "dashboard"){

            if (recados.code != 200) {
    
                $("#loadRecados").hide();
                $("#emptyRecados").removeClass("hide");
                $(".recado").addClass("hide");
    
                return;
            }

            $("#avatarRecado").attr("src", recados.list[0].estabelecimento.icone);
            $("#nomeECRecado").text(recados.list[0].estabelecimento.nome_fantasia);
            $("#dataRecado").text(recados.list[0].data);
            $("#dataRecadoMobile").text(recados.list[0].data);
            $(".body-recado .texto-recado").html(recados.list[0].recado);

            let emptyValues = ["", null, "null"];

            if(!emptyValues.includes(recados.list[0].anexos.imagem)){
                $("#imagemRecado").removeClass("hide");
                $("#imagemRecado img").attr("src",recados.list[0].anexos.imagem);
                $("#imagemRecado img").data("img",recados.list[0].anexos.imagem);
            }

            if(!emptyValues.includes(recados.list[0].anexos.link) || !emptyValues.includes(recados.list[0].anexos.arquivo)){
                $(".body-recado .anexos").removeClass("hide");
            }

            if(!emptyValues.includes(recados.list[0].anexos.link)){
                $(".body-recado .anexos .botao.link").removeClass("hide");
                $(".body-recado .anexos .botao.link").attr("href", recados.list[0].anexos.link);
            }

            if(!emptyValues.includes(recados.list[0].anexos.arquivo)){
                $(".body-recado .anexos .botao.arquivo").removeClass("hide");
                $(".body-recado .anexos .botao.arquivo").attr("href", recados.list[0].anexos.arquivo);
            }

            $(".recado").removeClass("hide");
            $("#loadRecados").hide();
            $("#emptyRecados").addClass("hide");

        }

        if($(".container").data("route") == "feed"){

            if (recados.code != 200) {
    
                $("#loadRecados").closest(".card").hide();
                $("#emptyRecados").removeClass("hide");
                $(".recados-list").addClass("hide");
    
                return;
            }

            var linha = "";

            recados.list.forEach(recado => {

                let emptyValues = ["", null, "null"];
                let temImagem = !emptyValues.includes(recado.anexos.imagem);
                let temLink = !emptyValues.includes(recado.anexos.link);
                let temArquivo = !emptyValues.includes(recado.anexos.arquivo);
    
                linha += `<div class="card">
                            <div class="conteudo">
                                <div class="recado">
                                    <div class="head-recado">
                                        <div class="flex">
                                            <div class="avatar">
                                                <img src="${recado.estabelecimento.icone}" alt="Avatar">
                                            </div>
                                            <div>
                                                <p class="nome">${recado.estabelecimento.nome_fantasia}</p>
                                                <div class="data mobile">${recado.data}</div>
                                            </div>
                                        </div>
                                        <div class="data desktop">${recado.data}</div>
                                    </div>`;
                linha +=           `<div class="body-recado">
                                        <div class="texto-recado">${recado.recado}</div>`;

                if(temImagem){
                    linha +=           `<div class="imagem">
                                            <img src="${recado.anexos.imagem}" alt="Imagem" data-img="${recado.anexos.imagem}">
                                        </div>`;
                }

                if(temLink || temArquivo){
                    linha +=           `<div class="anexos">`;

                    if(temLink){
                        linha +=           `<a target="_blank" href="${recado.anexos.link}" class="link botao secondary">
                                                <div class="icon"><span class="material-symbols-rounded">link</span></div>
                                                <p class="text">Acessar o link</p>
                                            </a>`;
                    }

                    if(temArquivo){
                        linha +=           `<a href="${recado.anexos.arquivo}" class="arquivo botao secondary" download>
                                                <div class="icon"><span class="material-symbols-rounded">draft</span></div>
                                                <p class="text">Baixar o arquivo</p>
                                            </a>`;
                    }

                    linha +=           `</div>`

                }

                linha +=           `</div>
                                </div>
                            </div>
                        </div>`;
            });

            $(".recados-list").html(linha);
            $("#loadRecados").closest(".card").hide();
            $(".recados-list, .column-40").removeClass("hide");
            $("#emptyRecados").addClass("hide");

            return;

        }

        if (recados.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(recados.message);

            $("#loadRecados").hide();
            $(".empty").removeClass("hide");
            $("#tableRecados").addClass("hide");

            return;
        }

        $(".numeroCadastrados").text(recados.quantidade);

        var linha = "";
        var cont = 1;

        recados.list.forEach(recado => {

            var textoRecado = recado.titulo;
            var disabledLink = "";
            var disabledArquivo = "";
            var disabledImagem = "";

            if(recado.anexos.link === null || recado.anexos.link === "" || recado.anexos.link.length === 0) disabledLink = "disabled";
            if(recado.anexos.arquivo === null || recado.anexos.arquivo === "" || recado.anexos.arquivo.length === 0) disabledArquivo = "disabled";
            if(recado.anexos.imagem === null || recado.anexos.imagem === "" || recado.anexos.imagem.length === 0) disabledImagem = "disabled";

            if(textoRecado.length >= 150){
                textoRecado = textoRecado.substring(0,147) + "...";
            }

            linha += `<tr data-id="${recado.id}">`;
                linha += `<td>${cont}</td>`;
                linha += `<td class="texto-recado">${textoRecado}</td>`;
                linha += `<td class="nowrap">${recado.data}</td>`;
                linha += `<td><div class="icones">`;
                    linha += `<a href="${recado.anexos.link}" target="_blank" class="icone-table abre-link ${disabledLink}"><span class="material-symbols-rounded">link</span></a>`;
                    linha += `<a href="${recado.anexos.arquivo}" download class="icone-table baixa-arquivo ${disabledArquivo}"><span class="material-symbols-rounded">draft</span></a>`;
                    linha += `<a href="${recado.anexos.imagem}" target="_blank" class="icone-table abre-imagem ${disabledImagem}"><span class="material-symbols-rounded">image</span></a>`;
                linha += `</div></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                    linha += `<div class="icone-table red exclui-recado"><span class="material-symbols-rounded">delete</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

            cont++;
        });

        $("#listaRecados").html(linha);
        $("#loadRecados").hide();
        $("#tableRecados").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        console.log(error);
        $(".msg .text").text(error);
    });
}

// monta os usuarios
const recuperaUsuarios = (statusUser = null, exclude = null, limit = null, perfil = null) => {

    let urlBase = "./controller/recupera_usuarios.php?";
    const params = new URLSearchParams();

    if(statusUser) params.append("status", statusUser);
    if(exclude) params.append("exclude", "sim");
    if(limit) params.append("limit", limit);
    if(perfil) params.append("perfil", perfil);

    let urlConsulta = urlBase + params.toString();

    $("#loadUsuarios").show();

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (usuarios) {

        if($(".container").data("route") == "home" || $(".container").data("route") == "dashboard"){

            if (usuarios.code != 200) {
    
                $("#loadUsuarios").hide();
                $("#emptyUsers").removeClass("hide");
                $("#listaUsuarios").addClass("hide");
                $("#btnVerUsuarios").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";

            usuarios.list.forEach(usuario => {

                let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=48&name="+usuario.nome;
    
                if(usuario.foto_perfil != null){
                    fotoPerfil = usuario.foto_perfil;
                }
    
                linha += `<li class="user">`;
                    linha += `<div class="dados">`;
                        linha += `<td><div class="img"><img src="${fotoPerfil}" alt="Imagem de perfil"></div></td>`;
                        linha += `<div class="column">`;
                            linha += `<p class="nome">${usuario.nome}</p>`;
                            linha += `<p class="email">${usuario.email}</p>`;
                        linha += `</div>`;
                    linha += `</div>`;
                    linha += `<a href="mailto:${usuario.email}" class="icone-table"><span class="material-symbols-rounded">mail</span></a>`;
                linha += `</li>`;
            });

            $("#listaUsuarios").html(linha);
            $("#loadUsuarios").hide();
            $(".loading").hide();
            $("#listaUsuarios").removeClass("hide");
            $("#btnVerUsuarios").removeClass("hide");
            $("#emptyUsers").addClass("hide");

            return;

        }

        if($(".container").data("route") == "lista-usuarios"){

            if (usuarios.code != 200) {
    
                $("#loadUsuarios").closest(".card").hide();
                $("#emptyUsers").removeClass("hide");
                $(".card-lista-usuarios").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";

            usuarios.list.forEach(usuario => {

                let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=48&name="+usuario.nome;
    
                if(usuario.foto_perfil != null && usuario.foto_perfil != ""){
                    fotoPerfil = usuario.foto_perfil;
                }
    
                linha += `<li class="user">`;
                    linha += `<div class="dados">`;
                        linha += `<td><div class="img"><img src="${fotoPerfil}" alt="Imagem de perfil"></div></td>`;
                        linha += `<div class="column">`;
                            linha += `<p class="nome">${usuario.nome}</p>`;
                            linha += `<p class="email">${usuario.email}</p>`;
                        linha += `</div>`;
                    linha += `</div>`;
                    linha += `<a href="mailto:${usuario.email}" class="icone-table"><span class="material-symbols-rounded">mail</span></a>`;
                linha += `</li>`;
            });

            $(".usuarios-list").html(linha);
            $("#loadUsuarios").closest(".card").hide();
            $(".loading").hide();
            $(".card-lista-usuarios").removeClass("hide");
            $("#emptyUsers").addClass("hide");

            return;

        }

        $("#ec_usuario").val(usuarios.estabelecimento);
        recuperaEstabelecimentos("2");

        if (usuarios.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(usuarios.message);

            $("#loadUsuarios").hide();
            $(".empty").removeClass("hide");
            $("#tableUsuarios").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(usuarios.quantidade);

        var linha = "";
        var cont = 1;

        usuarios.list.forEach(usuario => {

            let status = "Inativo";
            let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=40&name="+usuario.nome;

            if(usuario.status === "1"){
                status = "Ativo";
            }

            if(usuario.status === "2"){
                status = "Pendente";
            }

            if(usuario.foto_perfil != null){
                fotoPerfil = usuario.foto_perfil;
            }
            

            linha += `<tr data-id="${usuario.id}">`;
                // linha += `<td>${cont}</td>`;
                linha += `<td><div class="img"><img src="${fotoPerfil}" alt="Imagem de perfil"></div></td>`;
                linha += `<td>${usuario.nome}</td>`;
                linha += `<td>${usuario.documento}</td>`;
                linha += `<td>${usuario.email}</td>`;
                linha += `<td class="adm">${usuario.perfil_user}</td>`;
                linha += `<td><span class="tag h24 ${status.toLowerCase()}">${status}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                    // linha += `<div class="icone-table abre-email"><span class="material-symbols-rounded">mail</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

            cont++;
        });

        $("#listaUsuarios").html(linha);
        $("#loadUsuarios").hide();
        $(".loading").hide();
        $("#tableUsuarios").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        console.log(error);
        $(".msg .text").text(error);
    });
}

// monta os portais
const recuperaPortais = (status = null) => {

    let urlConsulta = "./controller/recupera_portais.php";

    if(status != null) urlConsulta = "./controller/recupera_portais.php?status="+status;

    $("#loadPortais").show();

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (portais) {

        if($(".container").data("route") == "lista-portais"){

            if (portais.code != 200) {
                $('.msg').addClass('on');
                $('.msg .text').text(portais.message);
    
                $("#loadPortais").closest(".card").hide();
                $("#emptyPortais").removeClass("hide");
                $(".portais-list-flex").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";

            portais.list.forEach(portal => {

                let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=48&name="+portal.nome;
                let ecPortal = "BB";

                if(portal.estabelecimento != "1"){
                    ecPortal = portal.nome_fantasia;
                }

                linha += `<div class="card"><div class="conteudo">`;
                    linha += `<div class="flex">`;
                        linha += `<div class="img"><img src="${fotoPerfil}" alt="Logo"></div>`;
                        linha += `<div><span class="tag h24">${ecPortal}</span></div>`;
                    linha += `</div>`;
                    linha += `<div class="detalhes">`;
                    linha += `<div class="titulo">${portal.nome}</div>`;
                    linha += `</div></div>`;
                        linha += `<a href="${portal.link}" target="_blank" class="botao auto-width secondary mt-3"><div class="text">Acessar o portal</div></a>`;
                    linha += `</div>`;
            });

            $(".portais-list-flex").html(linha);
            $("#loadPortais").closest(".card").hide();
            $(".loading").hide();
            $(".portais-list-flex").removeClass("hide");
            $("#emptyPortais").addClass("hide");

            return;

        }

        if($(".container").data("route") == "parceiros-bb"){

            if (portais.code != 200) {
                $('.msg').addClass('on');
                $('.msg .text').text(portais.message);
    
                $("#loadPortais").hide();
                $("#emptyPortais").removeClass("hide");
                $(".portais-list").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";

            portais.list.forEach(portal => {

                let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=40&name="+portal.nome;
                let ecPortal = "Banco do Brasil";

                if(portal.estabelecimento != "1"){
                    ecPortal = portal.nome_fantasia;
                }

                linha += `<li class="user">`;
                    linha += `<div class="dados">`;
                        linha += `<td><div class="img"><img src="${fotoPerfil}" alt="${portal.nome}"></div></td>`;
                        linha += `<div class="column">`;
                            linha += `<p class="nome">${portal.nome}</p>`;
                            linha += `<p class="email">${ecPortal}</p>`;
                        linha += `</div>`;
                    linha += `</div>`;
                    linha += `<a href="${portal.link}" target="_blank" class="icone-table"><span class="material-symbols-rounded">arrow_forward</span></a>`;
                linha += `</li>`;

                // linha += `<div class="card"><div class="conteudo">`;
                //     linha += `<div class="flex">`;
                //         linha += `<div class="img"><img src="${fotoPerfil}" alt="Logo"></div>`;
                //         linha += `<div><span class="tag h24">${ecPortal}</span></div>`;
                //     linha += `</div>`;
                //     linha += `<div class="detalhes">`;
                //     linha += `<div class="titulo">${portal.nome}</div>`;
                //     linha += `</div></div>`;
                //         linha += `<a href="${portal.link}" target="_blank" class="botao auto-width secondary mt-3"><div class="text">Acessar o portal</div></a>`;
                //     linha += `</div>`;
            });

            $(".portais-list").html(linha);
            $("#loadPortais").hide();
            $(".loading").hide();
            $(".portais-list").removeClass("hide");
            $("#emptyPortais").addClass("hide");

            return;

        }

        if (portais.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(portais.message);

            $("#loadPortais").closest(".card").hide();
            $("#emptyPortais").removeClass("hide");
            $(".card-lista-portais").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(portais.quantidade);

        var linha = "";

        portais.list.forEach(portal => {

            let status = "Inativo";
            let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=48&name="+portal.nome;

            if(portal.status === "1"){
                status = "Ativo";
            }

            if(portal.status === "2"){
                status = "Pendente";
            }

            linha += `<li class="user" data-id="${portal.id}">`;
                linha += `<div class="dados">`;
                    linha += `<td><div class="img"><img src="${fotoPerfil}" alt="Avatar"><div class="bullet ${status.toLowerCase()}"></div></div></td>`;
                    linha += `<div class="column">`;
                        linha += `<p class="nome">${portal.nome}</p>`;
                        linha += `<a target="_blank" class="email">${portal.link}</a>`;
                    linha += `</div>`;
                linha += `</div>`;
                linha += `<div class="icones">`;
                    linha += `<div class="status"><span class="tag h24 ${status.toLowerCase()}">${status}</span></div>`
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                linha += `</div>`;
            linha += `</li>`;
        });

        $(".portais-list").html(linha);
        $("#loadPortais").closest(".card").hide();
        $(".loading").hide();
        $(".card-lista-portais").removeClass("hide");
        $("#emptyPortais").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        console.log(error);
        $(".msg .text").text(error);
    });
}

// monta os parceiros
const recuperaParceiros = (status = null, order = null) => {

    let urlConsulta = "./controller/recupera_parceiros.php";

    if(status != null) urlConsulta = "./controller/recupera_parceiros.php?status="+status;

    if(status != null && order != null) urlConsulta = `./controller/recupera_parceiros.php?order=sim&status=${status}`;

    $("#loadParceiros").show();
    $("#tableParceiros").addClass("hide");

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (parceiros) {

        if($(".container").data("route") == "parceiros-bb"){

            if (parceiros.code != 200) {
                $('.msg').addClass('on');
                $('.msg .text').text(parceiros.message);
    
                $("#loadParceiros").hide();
                $("#emptyParceiro").removeClass("hide");
                $(".parceiros-list-flex").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";

            parceiros.list.forEach(parceiro => {

                let fotoPerfil = "https://ui-avatars.com/api/?rounded=false&background=ffffff&color=7a899f&bold=true&size=56&name="+parceiro.nome;

                if(parceiro.logo != null && parceiro.logo != ""){
                    fotoPerfil = parceiro.logo;
                }

                linha += `<li class="user">`;
                    linha += `<div class="dados">`;
                        linha += `<td><div class="img"><img src="${fotoPerfil}" alt="${parceiro.nome}"></div></td>`;
                        linha += `<div class="column">`;
                            linha += `<p class="nome">${parceiro.nome}</p>`;
                            linha += `<p class="email">${parceiro.email}</p>`;
                            linha += `<p class="email">${parceiro.telefone}</p>`;
                        linha += `</div>`;
                    linha += `</div>`;
                    linha += `<a href="${parceiro.site}" target="_blank" class="icone-table"><span class="material-symbols-rounded">arrow_forward</span></a>`;
                linha += `</li>`;

                // linha += `<div class="card"><div class="conteudo">`;
                //     linha += `<div class="img"><img src="${fotoPerfil}" alt="Logo"></div>`;
                //     linha += `<div class="detalhes">`;
                //     linha += `<div class="titulo">${parceiro.nome}</div>`;
                //     linha += `<p class="email"><span class="material-symbols-rounded">mail</span><i class="text">${parceiro.email}</i></p>`;
                //     linha += `<p class="telefone"><span class="material-symbols-rounded">phone</span>${parceiro.telefone}</p>`;
                //     linha += `</div></div>`;
                //         linha += `<a href="${parceiro.site}" target="_blank" class="botao auto-width primary mt-3"><div class="text">Acessar o site</div></a>`;
                //     linha += `</div>`;
            });

            $(".parceiros-list").html(linha);
            $("#loadParceiros").hide();
            $(".loading").hide();
            $(".parceiros-list").removeClass("hide");
            $("#emptyParceiro").addClass("hide");

            return;

        }

        if (parceiros.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(parceiros.message);

            $("#loadParceiros").hide();
            $(".empty").removeClass("hide");
            $("#tableParceiros").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(parceiros.quantidade);

        var linha = "";

        parceiros.list.forEach(parceiro => {

            let status = "Inativo";
            let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=40&name="+parceiro.nome;

            if(parceiro.status === "1"){
                status = "Ativo";
            }

            if(parceiro.logo != null && parceiro.logo != ""){
                fotoPerfil = parceiro.logo;
            }

            let site = parceiro.site.replace(/https?\:\/\/|www.|https?/ , '');
            

            linha += `<tr data-id="${parceiro.id}">`;
                linha += `<td><div class="img"><img src="${fotoPerfil}" alt="Logo"></div></td>`;
                linha += `<td>${parceiro.nome}</td>`;
                linha += `<td><a target="_blank" class="link-table" href="${parceiro.site}">${site}</a></td>`;
                linha += `<td>${parceiro.email}</td>`;
                linha += `<td><span class="tag h24 ${status.toLowerCase()}">${status}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;
        });

        $("#listaParceiros").html(linha);
        $("#loadParceiros").hide();
        $(".loading").hide();
        $("#tableParceiros").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta o faq
const recuperaFAQ = (status = null) => {

    let urlConsulta = "./controller/recupera_faq.php";

    if(status != null) urlConsulta = "./controller/recupera_faq.php?status="+status;

    $("#loadFAQ").show();
    $("#tableFAQ").addClass("hide");

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (perguntas) {

        if (perguntas.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(perguntas.message);

            $("#loadFAQ").hide();
            $(".empty").removeClass("hide");
            $("#tableFAQ").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(perguntas.quantidade);

        var linha = "";
        var cont = 1;

        perguntas.list.forEach(pergunta => {

            let status = "Inativo";

            if(pergunta.status === "1"){
                status = "Ativo";
            }

            var textoPergunta = pergunta.pergunta;
            var textoResposta = pergunta.resposta;

            if(textoPergunta.length >= 150){
                textoPergunta = textoPergunta.substring(0,147) + "...";
            }

            if(textoResposta.length >= 150){
                textoResposta = textoResposta.substring(0,147) + "...";
            }

            linha += `<tr data-id="${pergunta.id}">`;
                linha += `<td>${cont}</td>`;
                linha += `<td class="texto-pergunta">${textoPergunta}</td>`;
                linha += `<td>${pergunta.categoria}</td>`;
                linha += `<td><span class="tag h24 ${status.toLowerCase()}">${status}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

            cont++;
        });

        $("#listaFAQ").html(linha);
        $("#loadFAQ").hide();
        $(".loading").hide();
        $("#tableFAQ").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta os termos
const recuperaTermos = (status = null) => {

    let urlConsulta = "./controller/recupera_termos.php";

    if(status != null) urlConsulta = "./controller/recupera_termos.php?status="+status;

    $("#loadTermo").show();
    $("#tableTermo").addClass("hide");

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (termos) {

        if($(".container").data("route") == "termos-politicas") {

            if (termos.code != 200) {
                $(".loading").hide();
                $(".container").removeClass("hide");

                $("#emptyTermo").removeClass("hide");

                return;
            }

            var linha = "";

            termos.list.forEach(termo => {

                linha += `<div class="categoria" data-id="${termo.id}">`;
                linha += `<div class="text">${termo.titulo}</div>`;
                linha += `</div>`;
            });

            $(".categorias").html(linha);
            $("#loadTermo").closest(".card").hide();
            $(".categorias").show();
            $(".loading").hide();

            $(".categoria:first").addClass("ativo");
            let primeiroTermo = $(".categoria:first").data("id");

            recuperaDadosTermo(primeiroTermo);

            return;

        }

        if (termos.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(termos.message);

            $("#loadTermo").hide();
            $(".empty").removeClass("hide");
            $("#tableTermo").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(termos.quantidade);

        var linha = "";
        var cont = 1;

        termos.list.forEach(termo => {

            let status = "Inativo";

            if(termo.status === "1"){
                status = "Ativo";
            }

            var disabledArquivo = "";
            if(termo.anexo === null || termo.anexo === "" || termo.anexo.length === 0) disabledArquivo = "disabled";

            const data = new Date(termo.data_atualizacao);
            const dataTermo = data.toLocaleDateString();
            const horaTermo = data.toLocaleTimeString();

            linha += `<tr data-id="${termo.id}">`;
                linha += `<td>${cont}</td>`;
                linha += `<td>${termo.titulo}</td>`;
                linha += `<td>${dataTermo} ${horaTermo}</td>`;
                linha += `<td><span class="tag h24 ${status.toLowerCase()}">${status}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<a href="${termo.anexo}" download class="icone-table baixa-arquivo ${disabledArquivo}"><span class="material-symbols-rounded">draft</span></a>`;
                linha += `</div></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

            cont++;
        });

        $("#listaTermo").html(linha);
        $("#loadTermo").hide();
        $(".loading").hide();
        $("#tableTermo").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta o termo selecionado
const recuperaDadosTermo = (id) => {

    $(".anexo").addClass("hide");
    let urlConsulta = "./controller/consulta_termo.php?id="+id;

    $("#loadPolitica").closest(".card").removeClass("hide");
    $("#loadPolitica").show();
    $(".termo-content").addClass("hide");
    $(".termo-date").addClass("hide");

    sendFetchTermo(urlConsulta).then((resp) => resp.json()).then(function (termo) {

        if (termo.code) {

            $("#loadPolitica").closest(".card").hide();
            $(".termo-content").addClass("hide");

            $("#emptyTermo").removeClass("hide");

            return;
        }


        if(termo.data_atualizacao != null) {

            const data = new Date(termo.data_atualizacao);
            const dataTermo = data.toLocaleDateString();
            const horaTermo = data.toLocaleTimeString();
            $(".termo-date span").text(dataTermo + " às " + horaTermo);
            $(".termo-date").removeClass("hide");

        }

        if(termo.anexo != null && termo.anexo != "") {

            $(".anexo").removeClass("hide");
            $(".anexo .botao").attr("href",termo.anexo);

        }

        $(".termo-title").text(termo.titulo);
        $(".termo-text").html(termo.termo);

        $("#loadPolitica").closest(".card").addClass("hide");
        $(".termo-content").removeClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta as categorias da faq
const recuperaCategoriasFAQ = () => {

    let urlConsulta = "./controller/recupera_categorias_faq.php";

    $("#loadFAQ").show();
    $(".categorias").hide();

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (categorias) {

        if (categorias.code != 200) {

            $(".loading").hide();
            $(".container").removeClass("hide");

            $("#emptyFAQ").removeClass("hide");

            return;
        }

        var linha = "";

        categorias.list.forEach(categoria => {

            linha += `<div class="categoria" data-categoria="${categoria}">`;
                // linha += `<div class="circle"></div>`;
                linha += `<div class="text">${categoria}</div>`;
                linha += `</div>`;
        });

        $(".categorias").html(linha);
        $("#loadFAQ").closest(".card").hide();
        $(".categorias").show();
        $(".loading").hide();

        $(".categoria:first").addClass("ativo");
        let primeiraCategoria = $(".categoria:first .text").text();

        recuperaPerguntasPorCategoria(primeiraCategoria);

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta os videos
const recuperaVideos = (status = null) => {

    let urlConsulta = "./controller/recupera_videos.php";

    if(status != null) urlConsulta = "./controller/recupera_videos.php?status="+status;

    $("#loadVideo").show();
    $("#tableVideo").addClass("hide");

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (videos) {

        if($(".container").data("route") == "lista-videos"){

            if (videos.code != 200) {
                $('.msg').addClass('on');
                $('.msg .text').text(videos.message);
    
                $("#loadVideo").closest(".card").hide();
                $("#emptyVideos").removeClass("hide");
                $(".videos-list-flex").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";
            var linhaVert = "";

            if(videos.list.length < 5) {
                $(".filtros").remove();
            }

            if(videos.list.length == 1) {
                $(".column-40").remove();
                $(".column-60").css("width","100%");
            }

            videos.list.forEach((video, index) => {

                var videoID = getYouTubeId(video.link);
                var thumbnail = `http://img.youtube.com/vi/${videoID}/0.jpg`;

                const data = new Date(video.data_cadastro);
                const dataVideo = data.toLocaleDateString();
                const horaVideo = data.toLocaleTimeString();

                let ecVideo = "BB";

                if(video.estabelecimento != "1"){
                    ecVideo = video.nome_fantasia;
                }

                if(index == 0){
                    $(".video-maior .tag").text(ecVideo);
                    $(".video-maior .titulo").text(video.titulo);
                    $(".video-maior #dataVideo").text(dataVideo + " " + horaVideo);
                    $(".video-maior .video-destaque").attr("src","https://www.youtube.com/embed/"+videoID);
                    $(".video-maior .video-destaque").attr("title",video.titulo);
                }

                if(index > 0 && index < 4) {

                    var textoTitulo = video.titulo;

                    if(textoTitulo.length >= 30){
                        textoTitulo = textoTitulo.substring(0,27) + "...";
                    }

                    linhaVert += `<div class="conteudo video-flex">`;
                    linhaVert += `<iframe class="video" src="https://www.youtube.com/embed/${videoID}" title="${video.titulo}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>`;
                    linhaVert += `<div class="detalhes">`;
                    linhaVert += `<span class="tag h24">${ecVideo}</span>`;
                    linhaVert += `<div class="titulo" title="${video.titulo}">${textoTitulo}</div>`;
                    linhaVert += `<div class="data">${dataVideo} ${horaVideo}</div>`;
                    linhaVert += `</div></div>`;
                }

                if(index > 3) {
                    linha += `<div class="card"><div class="conteudo">`;
                    linha += `<iframe class="video" src="https://www.youtube.com/embed/${videoID}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>`;
                    linha += `<div class="detalhes">`;
                    linha += `<span class="tag h24">${ecVideo}</span>`;
                    linha += `<div class="titulo">${video.titulo}</div>`;
                    linha += `<div class="data">${dataVideo} ${horaVideo}</div>`;
                    linha += `</div></div>`;
                        // linha += `<a href="${video.link}" target="_blank" class="botao auto-width secondary mt-3"><div class="text">Assistir</div></a>`;
                    linha += `</div>`;
                }

                
            });

            $(".videos-list-flex").html(linha);
            $(".videos-vert").html(linhaVert);
            $("#loadVideo").closest(".card").hide();
            $(".loading").hide();
            $(".videos-list-flex, .videos-layout, .filtros").removeClass("hide");
            $("#emptyVideos").addClass("hide");

            return;

        }

        if (videos.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(videos.message);

            $("#loadVideo").hide();
            $(".empty").removeClass("hide");
            $("#tableVideo").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(videos.quantidade);

        var linha = "";

        videos.list.forEach(video => {

            let status = "Inativo";

            if(video.status === "1"){
                status = "Ativo";
            }

            var disabledVideo = "";
            if(video.link === null || video.link === "" || video.link.length === 0) disabledVideo = "disabled";

            var videoID = getYouTubeId(video.link);
            var thumbnail = `http://img.youtube.com/vi/${videoID}/default.jpg`;

            const data = new Date(video.data_cadastro);
            const dataVideo = data.toLocaleDateString();
            const horaVideo = data.toLocaleTimeString();

            linha += `<tr data-id="${video.id}">`;
                linha += `<td><div class="img thumb"><img src="${thumbnail}" alt="Logo"></div></td>`;
                linha += `<td>${video.titulo}</td>`;
                linha += `<td>${dataVideo} ${horaVideo}</td>`;
                linha += `<td><span class="tag h24 ${status.toLowerCase()}">${status}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<a href="${video.link}" target="_blank" class="icone-table ${disabledVideo}"><span class="material-symbols-rounded">play_circle</span></a>`;
                linha += `</div></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                    linha += `<div class="icone-table red exclui-video"><span class="material-symbols-rounded">delete</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

        });

        $("#listaVideo").html(linha);
        $("#loadVideo").hide();
        $(".loading").hide();
        $("#tableVideo").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta os manuais
const recuperaManuais = (status = null) => {

    let urlConsulta = "./controller/recupera_manuais.php";

    if(status != null) urlConsulta = "./controller/recupera_manuais.php?status="+status;

    $("#loadManual").show();
    $("#tableManual").addClass("hide");
    $("#emptyManual").addClass("hide");
    $(".numeroCadastrados").hide();

    sendFetch(urlConsulta).then((resp) => resp.json()).then(function (manuais) {

        if($(".container").data("route") == "lista-manuais"){

            if (manuais.code != 200) {
                $('.msg').addClass('on');
                $('.msg .text').text(manuais.message);
    
                $("#loadManual").closest(".card").hide();
                $("#emptyManual").removeClass("hide");
                $(".manuais-list-flex").addClass("hide");
                $(".loading").hide();
    
                return;
            }

            var linha = "";

            manuais.list.forEach(manual => {

                let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=48&name="+manual.titulo;

                const data = new Date(manual.data_cadastro);
                const dataManual = data.toLocaleDateString();
                const horaManual = data.toLocaleTimeString();

                linha += `<div class="card card-manual"><div class="conteudo">`;
                    // linha += `<div class="flex">`;
                        // linha += `<div class="img"><img src="${fotoPerfil}" alt="Logo"></div>`;
                    // linha += `</div>`;
                    linha += `<div class="detalhes">`;
                    linha += `<div class="titulo">${manual.titulo}</div>`;
                    linha += `<div class="email">${dataManual} ${horaManual}</div>`;
                    linha += `</div></div>`;
                        linha += `<a href="${manual.arquivo}" target="_blank" class="icone-table"><span class="material-symbols-rounded">book</span></a>`;
                        // linha += `<a href="${manual.arquivo}" target="_blank" class="botao auto-width secondary mt-3"><div class="text">Acessar manual</div></a>`;
                    linha += `</div>`;
            });

            $(".manuais-list-flex").html(linha);
            $("#loadManual").closest(".card").hide();
            $(".loading").hide();
            $(".manuais-list-flex").removeClass("hide");
            $("#emptyManual").addClass("hide");

            return;

        }

        if (manuais.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(manuais.message);

            $("#loadManual").hide();
            $(".empty").removeClass("hide");
            $("#tableManual").addClass("hide");
            $(".loading").hide();

            return;
        }

        $(".numeroCadastrados").text(manuais.quantidade);
        $(".numeroCadastrados").show();

        var linha = "";

        manuais.list.forEach(manual => {

            let status = "Inativo";

            if(manual.status === "1"){
                status = "Ativo";
            }

            var disabledManual = "";
            if(manual.arquivo === null || manual.arquivo === "" || manual.arquivo.length === 0) disabledManual = "disabled";

            let fotoPerfil = "https://ui-avatars.com/api/?rounded=true&bold=true&size=40&name="+manual.titulo;

            const data = new Date(manual.data_cadastro);
            const dataManual = data.toLocaleDateString();
            const horaManual = data.toLocaleTimeString();

            linha += `<tr data-id="${manual.id}">`;
                linha += `<td><div class="img"><img src="${fotoPerfil}" alt="Logo"></div></td>`;
                linha += `<td class="titulo-manual">${manual.titulo}</td>`;
                linha += `<td>${dataManual} ${horaManual}</td>`;
                linha += `<td><span class="tag h24 ${status.toLowerCase()}">${status}</span></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<a href="${manual.arquivo}" target="_blank" download class="icone-table ${disabledManual}"><span class="material-symbols-rounded">book</span></a>`;
                linha += `</div></td>`;
                linha += `<td><div class="icones">`;
                    linha += `<div class="icone-table abre-detalhes"><span class="material-symbols-rounded">visibility</span></div>`;
                    linha += `<div class="icone-table red exclui-manual"><span class="material-symbols-rounded">delete</span></div>`;
                linha += `</div></td>`;
            linha += `</tr>`;

        });

        $("#listaManual").html(linha);
        $("#loadManual").hide();
        $(".loading").hide();
        $("#tableManual").removeClass("hide");
        $(".empty").addClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// monta as perguntas da faq
const recuperaPerguntasPorCategoria = (categoria) => {

    let urlConsulta = "./controller/recupera_faq_por_categoria.php?categoria="+categoria;

    $("#loadPerguntas").closest(".card").removeClass("hide");
    $("#loadPerguntas").show();
    $(".perguntas").hide();

    sendFetchPerguntas(urlConsulta).then((resp) => resp.json()).then(function (perguntas) {

        if (perguntas.code != 200) {

            $("#loadPerguntas").closest(".card").hide();
            $(".perguntas").hide();

            $("#emptyFAQ").removeClass("hide");

            return;
        }

        var linha = "";

        perguntas.list.forEach(pergunta => {

            linha += `<div class="card sanfona pergunta"><div class="conteudo"><div class="head-sanfona">`;
            linha += `<p class="titulo">${pergunta.pergunta}</p>`;
            linha += `<span class="icone material-icons-round">expand_more</span></div>`;
            linha += `<div class="resposta dados">${pergunta.resposta}</div>`;
            linha += `</div></div>`;
        });

        $(".perguntas").html(linha);
        $("#loadPerguntas").closest(".card").addClass("hide");
        $(".perguntas").show();

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

const defineWL = (ec) => {
    // monta os parâmetros de WL
    if(ec === null) ec = "";
    const uniqueKey = Date.now().toString() + Math.random().toString().substr(2, 6);

    sendFetch("./controller/consulta_wl.php?ec="+ec).then((resp) => resp.json()).then(function (dados) {

        if (dados.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(dados.message);
            return;
        }

        document.documentElement.style.setProperty('--ui-color-primary', dados.wl.cor_primaria);
        document.documentElement.style.setProperty('--ui-color-secondary', dados.wl.cor_secundaria);
        
        $('.logo img').attr("src", dados.wl.logo + "?v=" + uniqueKey);
        $('.logo-header').attr("src", dados.wl.logo + "?v=" + uniqueKey);
        $('#favicon').attr("href", dados.wl.icone + "?v=" + uniqueKey);

        if($(".container").data("route") === "login"){
            $('img.logo').attr("src", dados.wl.logo + "?v=" + uniqueKey);
            $("#id_ec").val(dados.wl.estabelecimento);
        }

        if($(".container").data("route") === "recuperar-senha"){
            $('img.logo').attr("src", dados.wl.logo + "?v=" + uniqueKey);
            $("#voltarParaLogin").attr("href", "./login?ec="+ec);
        }

        if($(".container").data("route") === "cadastra-senha"){
            $('img.logo').attr("src", dados.wl.logo + "?v=" + uniqueKey);
        }

        if($(".container").data("route") === "cadastro"){
            $('img.logo').attr("src", dados.wl.logo + "?v=" + uniqueKey);
            $('#ec_cadastro').val(dados.wl.estabelecimento);
        }

        $(".loading").hide();
        $(".container").removeClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

const recuperaDados = () => {

    // monta os dados do cliente
    sendFetch("./controller/dados_usuario.php").then((resp) => resp.json()).then(function (dados) {

        const uniqueKey = Date.now().toString() + Math.random().toString().substr(2, 6);

        if (dados.code != 200) {
            $('.msg').addClass('on');
            $('.msg .text').text(dados.message);
            return;
        }

        defineWL(dados.estabelecimento.chave);

        const nomeCompleto = dados.usuario.nome.split(" ");
        const nome = nomeCompleto[0];
        const sobrenome = nomeCompleto.at(-1);
        const nomeAbreviado = nome + " " + sobrenome;

        sessionStorage.setItem("dados", JSON.stringify(dados));
        sessionStorage.setItem("nome_abreviado", nomeAbreviado);

        $(".dados .nome-usuario").text(nomeAbreviado).attr("title", nomeAbreviado);
        $(".dados .perfil-usuario").text(dados.estabelecimento.nome_fantasia);

        if(dados.usuario.foto_perfil != null) {
            if(dados.usuario.foto_perfil.length > 0) {
                $("#fotoPerfilSidebar").on("error", function(){
                    $(this).attr("src", "./assets/img/default_profile.svg");
                }).attr("src",dados.usuario.foto_perfil + "?v=" + uniqueKey);
            }
        };

        if($(".container").data("route") === "dashboard") {
            $("h3.title u").text(nomeAbreviado);
            $("#link").val(dados.ambiente.url+"cadastro?ec="+dados.estabelecimento.chave);
            recuperaUsuarios(null, "sim", 5);
            recuperaRecados(1);
        }

        if($(".container").data("route") === "home") {
            $("h3.title u").text(nomeAbreviado);
            $("#nomeEC").text(dados.estabelecimento.nome_fantasia);
            $("#link").val(dados.ambiente.url+"cadastro?ec="+dados.estabelecimento.chave);
        }

        if($(".container").data("route") === "estabelecimentos") {
            recuperaEstabelecimentos();
        }

        if($(".container").data("route") === "opcoes") {
            $("#field_link_blog").val(dados.opcoes.blog_mais_digital).addClass("input-active");

            if(dados.usuario.perfil != "Administrador"){
                $(".card-blog").remove();
            }
        }

        if($(".container").data("route") === "usuarios") {

            if(dados.usuario.perfil == "Administrador"){
                recuperaUsuarios(null, null, null, "all");
            }else{
                recuperaUsuarios();
            }

            if(dados.usuario.perfil != "Administrador"){
                $(".fields-admin, .last-divider, .adm").remove();
            }

        }

        if($(".container").data("route") === "videos") {
            recuperaVideos();
            $("#id_ec").val(dados.estabelecimento.id);
        }



        if($(".container").data("route") === "lista-videos") {
            recuperaVideos(1);
        }

        if($(".container").data("route") === "lista-manuais") {
            recuperaManuais(1);
        }

        if($(".container").data("route") === "manuais") {
            recuperaManuais();
        }

        if($(".container").data("route") === "termos") {
            recuperaTermos();
        }

        if($(".container").data("route") === "perguntas-frequentes") {
            recuperaCategoriasFAQ();
        }

        if($(".container").data("route") === "lista-usuarios") {
            recuperaUsuarios();
        }

        if($(".container").data("route") === "home") {
            recuperaUsuarios(null, "sim", 5);
            recuperaRecados(1);
            $("#linkAcessoBlogMaisDigital").attr("href",dados.opcoes.blog_mais_digital);
        }

        if($(".container").data("route") === "feed") {
            recuperaRecados();
            $("#link").val(dados.ambiente.url+"cadastro?ec="+dados.estabelecimento.chave);
            $("#linkAcessoBlogMaisDigital").attr("href",dados.opcoes.blog_mais_digital);
        }

        if($(".container").data("route") === "faq") {
            recuperaFAQ();
        }

        if($(".container").data("route") === "parceiros") {
            recuperaParceiros();
        }

        if($(".container").data("route") === "parceiros-bb") {
            recuperaParceiros(1, "sim");
            recuperaPortais(1);
        }

        if($(".container").data("route") === "portais") {
            recuperaPortais();
            $("#id_ec").val(dados.estabelecimento.id);
        }

        if($(".container").data("route") === "lista-portais") {
            recuperaPortais(1);
        }

        if($(".container").data("route") === "termos-politicas") {
            recuperaTermos(1);
        }

        if($(".container").data("route") === "recados") {
            recuperaRecados();
            $("#ec_recado").val(dados.estabelecimento.id);
        }

        if($(".container").data("route") === "painel") {
            $("h3.title u").text(nomeAbreviado);
        }

        if($(".container").data("route") === "perfil") {

            if(dados.usuario.foto_perfil != null) {
                if(dados.usuario.foto_perfil.length > 0) {
                    $("#imgPerfil").on("error", function(){
                        $(this).attr("src", "./assets/img/default_profile.svg");
                    }).attr("src",dados.usuario.foto_perfil + "?v=" + uniqueKey);
                    $("#deleteImage").removeClass("hide");
                }
            };

            $("#field_nome_representante").val(dados.usuario.nome).addClass("input-active");
            $("#field_dob").val(dados.usuario.data_nascimento).addClass("input-active");
            $("#field_cpf").val(dados.usuario.documento).addClass("input-active");
            $("#field_celular").val(dados.usuario.celular).addClass("input-active");
            $("#field_email").val(dados.usuario.email).addClass("input-active");
            $("#field_perfil").val(dados.usuario.perfil).addClass("input-active");
            $("#field_data_cadastro").val(dados.usuario.data_cadastro).addClass("input-active");

            if (dados.usuario.status === "1") {
                $("#field_status").val("Ativo");
            }else{
                $("#field_status").val("Inativo");
            }

            $("#ec_usuario_logado").val(dados.estabelecimento.chave);

        }

        $(".loading").hide();
        $(".container").removeClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
    });
}

// função que abre o pop-up
function abreModal(modal) {
    const modalBackdrop = $("#"+modal),
        modalArea = $(".inner-modal");

    // if(modalBackdrop.hasClass("scroll-off")){
    //     $("body, html, .container, .main").css("overflow","hidden");
    // }

    modalBackdrop.show().css("display", "flex");
    modalArea.delay(250).addClass("ativo");

    let alturaHeadBox = document.querySelector(".head-box").clientHeight;
    $(".ql-toolbar").css("top",alturaHeadBox);
}

// função que converte o url da imagem para base64
const converteEmBase64 = async (url) => {
    const data = await fetch(url);
    const blob = await data.blob();
    return new Promise((resolve) => {
        const reader = new FileReader();
        reader.readAsDataURL(blob);
        reader.onloadend = () => {
            const base64data = reader.result;
            resolve(base64data);
        }
    });
}

function preencheDadosEmpresa(dados) {
    // dados empresa
    $("#cnpj .valor").text(dados.parceiro.dados_registro.cnpj);
    $("#razao_social .valor").text(dados.parceiro.dados_registro.razao_social);
    $("#area_atuacao .valor").text(dados.parceiro.dados_registro.area_atuacao);
    $("#nome_fantasia .valor").text(dados.parceiro.dados_registro.nome_fantasia);

    $("#nome .valor").text(dados.usuario.nome);
    $("#data_nascimento .valor").text(dados.usuario.data_nascimento);
    $("#cpf .valor").text(dados.usuario.cpf);
    $("#celular .valor").text(dados.usuario.celular);
    $("#email .valor").text(dados.usuario.email);

    $("#cep .valor").text(dados.parceiro.endereco.cep);
    $("#numero .valor").text(dados.parceiro.endereco.numero);
    $("#bairro .valor").text(dados.parceiro.endereco.bairro);
    $("#uf .valor").text(dados.parceiro.endereco.uf);
    $("#logradouro .valor").text(dados.parceiro.endereco.logradouro);
    $("#complemento .valor").text(dados.parceiro.endereco.complemento);
    $("#cidade .valor").text(dados.parceiro.endereco.cidade);
    $("#ponto_referencia .valor").text(dados.parceiro.endereco.ponto_referencia);

    $("#banco .valor").text(dados.parceiro.dados_bancarios.banco);
    $("#agencia .valor").text(dados.parceiro.dados_bancarios.agencia);
    $("#tipo_conta .valor").text(dados.parceiro.dados_bancarios.tipo_conta);
    $("#pix .valor").text(dados.parceiro.dados_bancarios.pix);
    $("#conta .valor").text(dados.parceiro.dados_bancarios.conta);

    // dados formulario
    $("#field_cnpj").val(dados.parceiro.dados_registro.cnpj).addClass("input-active");
    $("#field_razao_social").val(dados.parceiro.dados_registro.razao_social).addClass("input-active");
    $("#field_area_atuacao").val(dados.parceiro.dados_registro.area_atuacao).addClass("input-active");
    $("#field_nome_fantasia").val(dados.parceiro.dados_registro.nome_fantasia).addClass("input-active");

    $("#field_nome_representante").val(dados.usuario.nome).addClass("input-active");
    $("#field_dob").val(dados.usuario.data_nascimento).addClass("input-active");
    $("#field_cpf").val(dados.usuario.cpf).addClass("input-active");
    $("#field_celular").val(dados.usuario.celular).addClass("input-active");
    $("#field_email").val(dados.usuario.email).addClass("input-active");
    $("#field_perfil").val(dados.usuario.perfil).addClass("input-active");
    $("#field_data_cadastro").val(dados.usuario.data_cadastro).addClass("input-active");

    $("#field_cep").val(dados.parceiro.endereco.cep).addClass("input-active");
    $("#field_numero").val(dados.parceiro.endereco.numero).addClass("input-active");
    $("#field_bairro").val(dados.parceiro.endereco.bairro).addClass("input-active");
    $("#field_uf").val(dados.parceiro.endereco.uf).addClass("input-active");
    $("#field_logradouro").val(dados.parceiro.endereco.logradouro).addClass("input-active");
    $("#field_complemento").val(dados.parceiro.endereco.complemento).addClass("input-active");
    $("#field_cidade").val(dados.parceiro.endereco.cidade).addClass("input-active");
    $("#field_referencia").val(dados.parceiro.endereco.ponto_referencia).addClass("input-active");

    $("#field_banco").val(dados.parceiro.dados_bancarios.banco).addClass("input-active");
    $("#field_agencia").val(dados.parceiro.dados_bancarios.agencia).addClass("input-active");
    $("#field_tipo_conta").val(dados.parceiro.dados_bancarios.tipo_conta).addClass("input-active");
    $("#field_pix").val(dados.parceiro.dados_bancarios.pix).addClass("input-active");
    $("#field_conta").val(dados.parceiro.dados_bancarios.conta).addClass("input-active");

    if (dados.usuario.status === "1") {
        $("#field_status").val("Ativo");
    }else{
        $("#field_status").val("Inativo");
    }

    if (dados.parceiro.status != "2") {
        $("#btnEditarDados, #modalDadosEmpresa").remove();
    }
}

function sticky(table) {
    $(window).on("scroll", function(){
        if($(table + " thead").position().top > 0){
            $(table + " thead").addClass("sticky");
        }else{
            $(table + " thead").removeClass("sticky");
        }
    });
}