$(function () {

    recuperaMenus();
    recuperaDados();

    let fileInput = $(".area-upload #nf_file");
    let fileCardName = $(".file-name .name");
    let fileCardSize = $(".file-name .size");
    let fileCard = $(".file-upload");

    fileInput.on('dragenter', function() {
        $('.area-upload').addClass('ativo');
    });

    fileInput.on('dragleave', function() {
        $('.area-upload').removeClass('ativo');
    });

    fileInput.on('drop', function() {
        $('.area-upload').removeClass('ativo');
    });

    fileInput.on("change", function({target}){
        let file = target.files[0];
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(fileSize > 3072) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 3 MB");
                return;
            }

            let fileSizeTotal;
            if(fileName.length >= 16){
                let splitName = fileName.split(".");
                fileName = splitName[0].substring(0,16) + "... ." + splitName[1];
            }
            if(fileSize < 1024){
                fileSizeTotal = fileSize.toFixed(0) + " KB";
            }else{
                fileSizeTotal = (fileSize / 1024).toFixed(2) + " MB";
            }
            fileCardName.text(fileName);
            fileCardSize.text(fileSizeTotal);
            fileCard.show();

            $("#btnEnviaNF").prop("disabled", false);
        }
        
    });

    $(".delete-file").on("click", function(){
        fileInput.val("");
        fileCard.hide();
        $("#btnEnviaNF").prop("disabled", true);
    });

    $(".abre-modal#btnModalNF").on("click", function(){
        abreModal("modalEnviaNF");
    });

    $("#fechaModalNF").on("click", function(){
        $("#modalEnviaNF").hide();
    });

    $("body").on("click", ".abre-options", function () {
        $(".options").hide();
        $(this).parent().find(".options").show();
    });

    // fecha options
    $("body").click(function (e) {
        var condicao = $(e.target).is(".options *") || $(e.target).is(".options") || $(e.target).is(".abre-options *") || $(e.target).is(".abre-options");

        if (!condicao) {
            $(".options").hide();
        }
    });

    $("body").on("click",".baixa-nf", function(){
        const file = $(this).data("file");
        const link = document.createElement("a");
        link.href = file;
        link.download = "";
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });

    // cadastra nf
    function sendFetchDados() {
        $("#loadEnviaNF").show();
        $("#btnEnviaNF .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formEnviaNF").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/envia_nf.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnEnviaNF .text").show();
                $("#loadEnviaNF").hide();
                return;
            }
            
            $("#btnEnviaNF .text").show();
            $("#loadEnviaNF").hide();

            $("#btnEnviaNF").attr("disabled", true);

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            $(".container").addClass("hide");

            recuperaDados();
            $(".modal").hide();
            $(".nfList").html("");

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    
});