$(function () {

    recuperaMenus();
    recuperaDados();

    var uniqueKey = Date.now().toString() + Math.random().toString().substr(2, 6);

    validationForm("formLinkBlog");
    verificaInputsRequired("formLinkBlog");
    validationForm("formBrand");
    verificaInputsRequired("formBrand");

    var dados = JSON.parse(sessionStorage.getItem("dados"));

    // atualizar link do blog
    function sendFetchBlog() {
        $("#loadBlog").show();
        $("#btnAtualizaLinkBlog .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formLinkBlog").submit(function (e) {
        e.preventDefault();

        sendFetchBlog("./controller/atualiza_link_blog.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaLinkBlog .text").show();
                $("#loadBlog").hide();
                return;
            }
            
            $("#btnAtualizaLinkBlog .text").show();
            $("#loadBlog").hide();

            $("#btnAtualizaLinkBlog").attr("disabled", true);

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $(".field-hexa").on("keyup", function(){
        $(this).next().next().css("background-color",$(this).val());
    });

    let fileInput = $(".label-upload input");

    fileInput.on("change", function({target}){

        let file = target.files[0];
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(file.type != "image/png") {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo no formato PNG");
                return;
            }

            if(fileSize > 3072) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 3 MB");
                return;
            }

            if(fileName.length >= 8){
                let splitName = fileName.split(".");
                fileName = splitName[0].substring(0,8) + "... ." + splitName[1];
            }

            $("#"+target.id).closest(".label-upload").next().parent().find(".path").text(fileName);
            $("#"+target.id).closest(".label-upload").next().parent().find("img").attr("src",URL.createObjectURL(file));
            $("#"+target.id).closest(".label-upload").next().show().css("display", "flex");
            
        }

        verificarInputsObrigatorios("formBrand");
        
    });

    $(".delete").on("click", function(){
        $(this).closest(".flex-upload").parent().find("input").val("");
        $(this).closest(".logo-preview").hide();

        $("#btnAtualizaBrand").attr("disabled", true);
    });

    function sendFetchAtualizaDados() {
        $("#btnAtualizaBrand .load").show();
        $("#btnAtualizaBrand .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formBrand").submit(function (e) {
        e.preventDefault();
        
        let cnpj = dados.estabelecimento.cnpj;

        sendFetchAtualizaDados("./controller/atualiza_brand_estabelecimento.php?cnpj="+cnpj, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaBrand .text").show();
                $("#btnAtualizaBrand .load").hide();
                return;
            }
            
            $("#btnAtualizaBrand .text").show();
            $("#btnAtualizaBrand .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    let idEstabelecimento = dados.estabelecimento.id;

    function sendFetchDetalhes() {
        $("#formBrand .load-usuarios").show();
        $("#formBrand .fields").addClass("hide");
        return fetch.apply(this, arguments);
    }

    sendFetchDetalhes("./controller/consulta_estabelecimento.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

        if (dados.code) {
            $(".msg").addClass("on");
            $(".msg .text").text(dados.message);
            return;
        }

        $("#field_cor_primaria_dados").val(dados.cor_primaria).addClass("input-active");
        $("#field_cor_primaria_dados").next().next().css("background",dados.cor_primaria);
        $("#field_cor_secundaria_dados").val(dados.cor_secundaria).addClass("input-active");
        $("#field_cor_secundaria_dados").next().next().css("background",dados.cor_secundaria);

        if(dados.logo.split("/")[4].length >= 8){
            let splitNameLogo = dados.logo.split("/")[4].split(".");
            var fileNameLogo = splitNameLogo[0].substring(0,8) + "... ." + splitNameLogo[1];
        }

        $("#field_logo_dados").closest(".label-upload").next().parent().find(".path").text(fileNameLogo);
        $("#field_logo_dados").closest(".label-upload").next().parent().find("img").attr("src",dados.logo + "?v=" + uniqueKey);
        $("#field_logo_dados").closest(".label-upload").next().show().css("display", "flex");

        if(dados.icone.split("/")[4].length >= 8){
            let splitNameIcone = dados.icone.split("/")[4].split(".");
            var fileNameIcone = splitNameIcone[0].substring(0,8) + "... ." + splitNameIcone[1];
        }

        $("#field_icone_dados").closest(".label-upload").next().parent().find(".path").text(fileNameIcone);
        $("#field_icone_dados").closest(".label-upload").next().parent().find("img").attr("src",dados.icone + "?v=" + uniqueKey);
        $("#field_icone_dados").closest(".label-upload").next().show().css("display", "flex");

        verificarInputsPreenchidos("formBrand");

        $("#formBrand .load-usuarios").hide();
        $("#formBrand .fields").removeClass("hide");

    }).catch(function (error) {
        $(".msg").addClass("on");
        $(".msg .text").text(error);
        console.log(error);
    });

});