$(function () {

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoParceiro");
    verificaInputsRequired("formNovoParceiro");
    validationForm("formDadosParceiro");
    verificaInputsRequired("formDadosParceiro");

    // abre modal de cadastrar parceiro
    $("#btnCadastrarParceiro").click(function () {
        abreModal("modalNovoParceiro");
    });

    $("#fechaModalNovoParceiro").click(() => {
        $("#modalNovoParceiro").hide();
    });

    $("#pesquisaLivre").on("input change", function () {
        $("#listaParceiros tr").removeClass("result-on");

        if ($(this).val() != "") {
            $("#listaParceiros tr").hide();
            $("#listaParceiros tr:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $("#listaParceiros tr").show();
        }

        if($(this).val() === "Todos") {
            $("#listaParceiros tr").show();
            $(".empty-search").addClass("hide");
            $("#tableParceiros").show();
        }
    });

    $("#pesquisaLivreParceiro").on("input change", function () {
        $(".parceiros-list li").removeClass("result-on");

        if ($(this).val() != "") {
            $(".parceiros-list li").hide();
            $(".parceiros-list li:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultadosListParceiros();
        } else {
            $(".parceiros-list li").show();
        }
    });

    $("#pesquisaLivrePortais").on("input change", function () {
        $(".portais-list li").removeClass("result-on");

        if ($(this).val() != "") {
            $(".portais-list li").hide();
            $(".portais-list li:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultadosListPortais();
        } else {
            $(".portais-list li").show();
        }
    });

    $("#resetaFiltros").on("click", function(e){
        e.preventDefault();
        $("#pesquisaLivre").val("").removeClass("input-active");
        $("#pesquisaLivreCards").val("").removeClass("input-active");
        $("#listaParceiros tr").show();
        $(".parceiros-list-flex .card").show();
        $(".empty-search").addClass("hide");
        $("#tableParceiros").show();
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $(".empty-search").removeClass("hide");
            $("#tableParceiros").hide();
        } else {
            $(".empty-search").addClass("hide");
            $("#tableParceiros").show();
        }
    }

    function contaResultadosListParceiros() {
        var resultados = $(".parceiros-list .result-on").length;
        if (resultados === 0) {
            $("#emptyParceiro").removeClass("hide");
            $(".parceiros-list").hide();
        } else {
            $("#emptyParceiro").addClass("hide");
            $(".parceiros-list").show();
        }
    }

    function contaResultadosListPortais() {
        var resultados = $(".portais-list .result-on").length;
        if (resultados === 0) {
            $("#emptyPortais").removeClass("hide");
            $(".portais-list").hide();
        } else {
            $("#emptyPortais").addClass("hide");
            $(".portais-list").show();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

    function sendFetchDados() {
        $("#btnCadastraParceiro .load").show();
        $("#btnCadastraParceiro .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoParceiro").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_parceiro.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraParceiro .text").show();
                $("#btnCadastraParceiro .load").hide();
                return;
            }
            
            $("#btnCadastraParceiro .text").show();
            $("#btnCadastraParceiro .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosParceiro .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaParceiros").on("click",".abre-detalhes", function () {

        abreModal("modalDadosParceiro");
        const idParceiro = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_parceiro.php?id="+idParceiro).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#field_nome_dados").val(dados.nome).addClass("input-active");
            $("#field_telefone_dados").val(dados.telefone).addClass("input-active");
            $("#field_email_dados").val(dados.email).addClass("input-active");
            $("#field_site_dados").val(dados.site).addClass("input-active");

            if(dados.logo != "" && dados.logo != null){
                var logoName = dados.logo.split("/")[4];

                if(logoName.length >= 24){
                    var fileNameLogo = logoName.substring(0,12) + "..." + logoName.substring(logoName.length - 12);
                }else{
                    fileNameLogo = logoName;
                }
    
                $("#field_logo_dados").closest(".label-upload").next().parent().find(".path").text(fileNameLogo);
                $("#field_logo_dados").closest(".label-upload").next().parent().find("img").attr("src",dados.logo);
                $("#field_logo_dados").closest(".label-upload").next().show().css("display", "flex");
            }

            let status;
            dados.status === "0" ? status = "inativo" : status = "ativo";

            $("#tagStatus").text("Parceiro "+status).addClass(status).show().css("display", "inline-flex");

            verificarInputsPreenchidos("formDadosParceiro");

            $(".altera-status").data("id", dados.id);
            $("#btnAtualizaParceiro").data("id", dados.id);
            
            $("#modalDadosParceiro .load-detalhes").hide();
            $("#formDadosParceiro").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosParceiro").click(() => {
        closeModalParceiro();
    });

    function closeModalParceiro(){
        $("#tagNumeroUsuarios, #tagStatus, #modalDadosParceiro, #formDadosParceiro").hide();
        $("#modalDadosParceiro .load-detalhes").show();
        $("#btnAtualizaParceiro").attr("disabled", false);
        $("#tagStatus").removeClass("ativo inativo");
    }

    $("#abreOpcoes").on("click", function () {
        $("#optionsParceiro").show();
    });

    // fecha options
    $("body").click(function (e) {
        var condicao = $(e.target).is(".options *") || $(e.target).is(".options") || $(e.target).is(".abre-options *") || $(e.target).is(".abre-options");

        if (!condicao) {
            $(".options").hide();
        }
    });

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
    });

    function sendFetchStatus() {
        $("#modalAlteraStatus .load-status").show();
        return fetch.apply(this, arguments);
    }

    $(".altera-status").on("click", function(){
        abreModal("modalAlteraStatus");
        const idParceiro = $(this).data("id");

        sendFetchStatus("./controller/consulta_parceiro.php?id="+idParceiro).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#nomeParceiro").text(dados.nome);
            $("#field_hidden_status").val(dados.status);
            $("#field_hidden_id").val(dados.id);

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";
            $("#statusParceiro").text(status).addClass(status.toLowerCase());

            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");
            
            $("#modalAlteraStatus .load-status").hide();
            $("#formAlteraStatus").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });

    });

    $("#fechaModalAlteraStatus").click(() => {
        closeModalAlteraStatus();
    });

    function closeModalAlteraStatus(){
        $("#modalAlteraStatus, #formAlteraStatus").hide();
        $("#modalAlteraStatus .load-status").show();
        $("#statusParceiro").removeClass("ativo inativo");
    }

    function sendFetchSalvaStatus() {
        $("#btnAlteraStatus .load").show();
        $("#btnAlteraStatus .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formAlteraStatus").submit(function (e) {
        e.preventDefault();

        sendFetchSalvaStatus("./controller/altera_status_parceiro.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAlteraStatus .text").show();
                $("#btnAlteraStatus .load").hide();
                return;
            }
            
            $("#btnAlteraStatus .text").show();
            $("#btnAlteraStatus .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            closeModalParceiro();
            closeModalAlteraStatus();
            recuperaDados();
            $(".modal").hide();

            console.log(data);

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
            console.log(error);
        });
    });

    let fileInput = $(".label-upload input");

    fileInput.on("change", function({target}){
        let file = target.files[0];
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(file.type != "image/png") {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo no formato PNG");
                return;
            }

            if(fileSize > 3072) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 3 MB");
                return;
            }

            if(fileName.length >= 24){
                fileName = fileName.substring(0,12) + "..." + fileName.substring(fileName.length - 12);
            }

            $("#"+target.id).closest(".label-upload").next().parent().find(".path").text(fileName);
            $("#"+target.id).closest(".label-upload").next().parent().find("img").attr("src",URL.createObjectURL(file));
            $("#"+target.id).closest(".label-upload").next().show().css("display", "flex");

            verificaInputsRequired("formNovoParceiro");
            $("#btnAtualizaParceiro").attr("disabled", false);
        }
        
    });

    $(".delete").on("click", function(){
        $(this).closest(".flex-upload").parent().find("input").val("");
        $(this).closest(".logo-preview").hide();

        $(this).next().val("sim");
        $("#btnAtualizaParceiro").attr("disabled", false);
    });

    sticky("#parceirosTable");

    function sendFetchAtualizaDados() {
        $("#btnAtualizaParceiro .load").show();
        $("#btnAtualizaParceiro .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosParceiro").submit(function (e) {
        e.preventDefault();

        const idParceiro = $("#btnAtualizaParceiro").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_parceiro.php?id="+idParceiro, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaParceiro .text").show();
                $("#btnAtualizaParceiro .load").hide();
                return;
            }
            
            $("#btnAtualizaParceiro .text").show();
            $("#btnAtualizaParceiro .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});