$(function(){

    validationForm("formAlterarSenha");

    var url = new URL(window.location);
    var ec = url.searchParams.get("ec");

    defineWL(ec);

    $("#field_nova_senha").on("keyup", function () {
        validaSenha("#btnAtualizaSenha","#field_nova_senha");
    });

    $("#field_senha_confirm").on("keyup", function(){
        if($(this).val() != $("#field_nova_senha").val()){
            $(this).addClass("field-error");
            contaErros("formAlterarSenha");
            $(".msg").addClass("on");
            $(".msg .text").text("As senhas não correspondem");
        }else{
            $(this).removeClass("field-error");
            contaErros("formAlterarSenha");
            $(".msg").removeClass("on");
        }
    });

    let token = sessionStorage.getItem("token");

    if(token === null || token === "" || token.length === 0){
        location.href = './404';
    }

    $("#token").val(token);

    // função que envia as requisições para o servidor
    function sendFetch(){
        $("#load").show();
        return fetch.apply(this, arguments);
    }

    // envia a requisição de login
    $("#formAlterarSenha").submit(function(e){
        e.preventDefault();

        sendFetch("./controller/recupera_senha_usuario.php",{
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function(data){
            
            $("#load").hide();
            $(".msg").addClass("on");
            $(".msg .text").text(data.message);
            if(data.code === 200) {
                setTimeout(function() {
                    location.href = data.route + "/" + ec;
                }, 1500);
            }

        }).catch(function(error){
            $("#load").hide();
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});