$(function () {

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoUsuario");
    verificaInputsRequired("formNovoUsuario");
    validationForm("formDadosUsuario");
    verificaInputsRequired("formDadosUsuario");

    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarUsuario").click(function () {
        abreModal("modalNovoUsuario");
    });

    $("#fechaModalNovoUsuario").click(() => {
        $("#modalNovoUsuario").hide();
    });

    $("#pesquisaLivre, #pesquisaCNPJ").on("input change", function () {
        $("#listaUsuarios tr").removeClass("result-on");

        if ($(this).val() != "") {
            $("#listaUsuarios tr").hide();
            $("#listaUsuarios tr:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $("#listaUsuarios tr").show();
        }
    });

    $("#pesquisaListaUser").on("input change", function () {
        $(".usuarios-list li").removeClass("result-on");

        if ($(this).val() != "") {
            $(".usuarios-list li").hide();
            $(".usuarios-list li:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $(".usuarios-list li").show();
        }
    });

    $("#selectStatus").on("change", function () {
        if($(this).val() == "Todos"){
            recuperaUsuarios();
            return;
        }

        recuperaUsuarios($(this).val());
    });

    $("#pesquisaLivre").on("input", function () {
        $("#pesquisaCNPJ").val("").removeClass("input-active");
    });

    $("#pesquisaCNPJ").on("input", function () {
        $("#pesquisaLivre").val("").removeClass("input-active");
    });

    $("#resetaFiltros").on("click", function(e){
        e.preventDefault();
        $("#pesquisaLivre, #pesquisaCNPJ").val("").removeClass("input-active");
        $("#selectStatus").next().parent().find(".current").text("Todos");
        recuperaUsuarios();
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $(".empty-search").removeClass("hide");
            $("#tableUsuarios").hide();
        } else {
            $(".empty-search").addClass("hide");
            $("#tableUsuarios").show();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

    function sendFetchDados() {
        $("#btnCadastraUsuario .load").show();
        $("#btnCadastraUsuario .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoUsuario").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_usuario.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraUsuario .text").show();
                $("#btnCadastraUsuario .load").hide();
                return;
            }
            
            $("#btnCadastraUsuario .text").show();
            $("#btnCadastraUsuario .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosUsuario .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaUsuarios").on("click",".abre-detalhes", function () {

        abreModal("modalDadosUsuario");
        const idUsuario = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_usuario.php?id="+idUsuario).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#field_nome_dados").val(dados.nome).addClass("input-active");
            $("#field_cpf_dados").val(dados.documento).addClass("input-active");
            $("#field_data_nascimento_dados").val(dados.data_nascimento).addClass("input-active");
            $("#field_celular_dados").val(dados.celular).addClass("input-active");
            $("#field_email_dados").val(dados.email).addClass("input-active");

            // const data = new Date(dados.data_cadastro);
            // $("#field_data_cadastro_dados").val(data.toLocaleDateString()).addClass("input-active");

            let status;

            switch(dados.status){
                case "0":
                    status = "inativo";
                    break;
                case "1":
                    status = "ativo";
                    break;
                case "2":
                    status = "pendente";
                    break;
            }

            $("#tagStatus").text("Usuário "+status).addClass(status).show().css("display", "inline-flex");

            verificarInputsPreenchidos("formDadosUsuario");

            $(".altera-status").data("id", dados.id);
            $(".enviar-email").data("id", dados.id);
            $("#btnAtualizaUsuario").data("id", dados.id);
            
            $("#modalDadosUsuario .load-detalhes").hide();
            $("#formDadosUsuario").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosUsuario").click(() => {
        closeModalUsuario();
    });

    function closeModalUsuario(){
        $("#tagStatus, #modalDadosUsuario, #formDadosUsuario").hide();
        $("#modalDadosUsuario .load-detalhes").show();
        $("#modalDadosUsuario .botao-submit").attr("disabled", true);
        $("#tagStatus").removeClass("ativo inativo pendente");
    }

    $("#abreOpcoes").on("click", function () {
        $("#optionsUsuario").show();
    });

    // fecha options
    $("body").click(function (e) {
        var condicao = $(e.target).is(".options *") || $(e.target).is(".options") || $(e.target).is(".abre-options *") || $(e.target).is(".abre-options");

        if (!condicao) {
            $(".options").hide();
        }
    });

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
    });

    function sendFetchStatus() {
        $("#modalAlteraStatus .load-status").show();
        return fetch.apply(this, arguments);
    }

    $(".altera-status").on("click", function(){
        abreModal("modalAlteraStatus");
        const idUsuario = $(this).data("id");

        sendFetchStatus("./controller/consulta_usuario.php?id="+idUsuario).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#nomeColaborador").text(dados.nome);
            $("#field_hidden_status").val(dados.status);
            $("#field_hidden_id").val(dados.id);

            let status;

            switch(dados.status){
                case "0":
                    status = "Inativo";
                    break;
                case "1":
                    status = "Ativo";
                    break;
                case "2":
                    status = "Pendente";
                    break;
            }

            $("#statusColaborador").text(status).addClass(status.toLowerCase());

            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");
            
            $("#modalAlteraStatus .load-status").hide();
            $("#formAlteraStatus").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });

    });

    function sendFetchEmail() {
        $("#modalEnviaEmail .load-email").show();
        return fetch.apply(this, arguments);
    }

    $(".enviar-email").on("click", function(){
        abreModal("modalEnviaEmail");
        const idUsuario = $(this).data("id");

        sendFetchEmail("./controller/consulta_usuario.php?id="+idUsuario).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#nomeUser").text(dados.nome);
            $("#emailUser").text(dados.email);
            $("#hidden_email").val(dados.email);
            $("#btnAbrirEmail").attr("href",`mailto:${dados.email}`);
            
            $("#modalEnviaEmail .load-email").hide();
            $("#formEnviaEmail").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });

    });

    jQuery('#btnCopiarEmail').click(function () {
        jQuery('#hidden_email').select();
        try {
            var ok = document.execCommand('copy');
            if (ok) {

                jQuery("#btnCopiarEmail .text").text("E-mail copiado");
                jQuery("#btnCopiarEmail").addClass("sucesso");

                setTimeout(function () {

                    jQuery("#btnCopiarEmail .text").text("Copiar e-mail");
                    jQuery("#btnCopiarEmail").removeClass("sucesso");

                }, 3000);

            }
        } catch (e) {
            alert(e);
        }
    });

    $("#fechaModalAlteraStatus").click(() => {
        closeModalAlteraStatus();
    });

    $("#fechaModalEnviaEmail").click(() => {
        closeModalEnviaEmail();
    });

    function closeModalAlteraStatus(){
        $("#modalAlteraStatus, #formAlteraStatus").hide();
        $("#modalAlteraStatus .load-status").show();
        $("#statusColaborador").removeClass("ativo inativo pendente");
    }

    function closeModalEnviaEmail(){
        $("#modalEnviaEmail, #formEnviaEmail").hide();
        $("#modalEnviaEmail .load-email").show();
    }

    function sendFetchSalvaStatus() {
        $("#btnAlteraStatus .load").show();
        $("#btnAlteraStatus .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formAlteraStatus").submit(function (e) {
        e.preventDefault();

        sendFetchSalvaStatus("./controller/altera_status_usuario.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAlteraStatus .text").show();
                $("#btnAlteraStatus .load").hide();
                return;
            }
            
            $("#btnAlteraStatus .text").show();
            $("#btnAlteraStatus .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            closeModalUsuario();
            closeModalAlteraStatus();
            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
            console.log(error);
        });
    });

    sticky("#usuariosTable");

    function sendFetchAtualizaDados() {
        $("#btnAtualizaUsuario .load").show();
        $("#btnAtualizaUsuario .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosUsuario").submit(function (e) {
        e.preventDefault();

        const idUsuario = $("#btnAtualizaUsuario").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_usuario.php?id="+idUsuario, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaUsuario .text").show();
                $("#btnAtualizaUsuario .load").hide();
                return;
            }
            
            $("#btnAtualizaUsuario .text").show();
            $("#btnAtualizaUsuario .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#field_perfil").on("change", function(){
        recuperaEstabelecimentos($(this).val());
    });

});