function contaErros(formID) {
    var erros = $("#"+formID+" .field-error").length;
    if (erros > 0) {
        $("#"+formID+" .botao-submit").attr("disabled", true);
    } else {
        $("#"+formID+" .botao-submit").removeAttr("disabled");
    }
}

$("#field_logo_dados, #field_icone_dados").on("change", function(){
    contaErros("formDadosEstabelecimento");
});

function verificaInputsRequired(container){

    var inputs = $('#'+container+' [required]');
    inputs.on('keyup change', verificarInputs);

    function verificarInputs() {
        var preenchidos = true;
        inputs.each(function () {
            if (!this.value || $(this).hasClass("field-error")) {
              preenchidos = false;
              return false;
            }
        });
        $('#'+container+' .botao-submit').prop('disabled', !preenchidos);
    }
}

function verificarInputsObrigatorios(container) {
    var preenchidos = true;
    $('#'+container+' [required]').each(function () {
        if (!this.value || $(this).hasClass("field-error")) {
          preenchidos = false;
          return false;
        }
    });
    $('#'+container+' .botao-submit').prop('disabled', !preenchidos);
}

function verificarInputsPreenchidos(container) {
    $('#'+container+' input').each(function () {
        if (!this.value || $(this).hasClass("field-error")) {
          $(this).removeClass("input-active");
          return false;
        }
    });
}

$(function(){

    $(".input").on("blur keyup change", function(){
        if($(this).val().length > 0) {
            $(this).addClass("input-active");
        }else{
            $(this).removeClass("input-active");
        }
    });

    $(".input").each(function(){
        if($(this).val().length > 0) {
            $(this).addClass("input-active");
        }else{
            $(this).removeClass("input-active");
        }
    });
});


function validationForm(form) {
    var botao = $("#"+form+" .botao-submit");
    var email = $(".field-email");
    var cnpj = $(".field-cnpj");
    var cpf = $(".field-cpf");
    var data = $(".field-data");
    var celular = $(".field-celular");
    var cep = $(".field-cep");
    var field = $(".field-default");
    var hexa = $(".field-hexa");
    var emailPreenchido = false;
    var cnpjPreenchido = false;
    var cpfPreenchido = false;

    // validação geral se os campos estão preenchidos ou vazios
    $("#"+form+" [required]").on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        if ($(this).val() == "") {
            $(this).addClass("field-error");
            contaErros(formID);
        } else {
            $(this).removeClass("field-error");
            contaErros(formID);
        }
    });

    //validação do email
    function isEmail(email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return regex.test(email);
    }
    email.on("keyup", function (e) {
        emailPreenchido = isEmail($(this).val());
        var formID = e.target.closest("form").id;
        if (emailPreenchido === false) {
            $(this).addClass("field-error");
            contaErros(formID);
            return;
        }
        $(this).removeClass("field-error");
    });

    //validação de cnpj
    cnpj.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        var cnpjFormatado = $(this).val().replace(/[^0-9]/g, '');
        cnpjPreenchido = valida_cpf_cnpj(cnpjFormatado);
        if (cnpjFormatado.length < 14) {
            $(this).addClass("field-error");
            contaErros(formID);
        } else {
            if (cnpjPreenchido === false || cnpjFormatado == "00000000000000") {
                $(this).addClass("field-error");
                contaErros(formID);
                return;
            }
            $(this).removeClass("field-error");
        }
    });

    //validação de cpf
    cpf.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        var cpfFormatado = $(this).val().replace(/[^0-9]/g, '');
        cpfPreenchido = valida_cpf_cnpj(cpfFormatado);
        if (cpfFormatado.length < 11) {
            $(this).addClass("field-error");
            contaErros(formID);
        } else {
            if (cpfPreenchido === false || cpfFormatado == "00000000000") {
                $(this).addClass("field-error");
                contaErros(formID);
                return;
            }
            $(this).removeClass("field-error");
        }
    });

    // validação de data
    data.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        var etapaID = e.target.closest(".inner-box").id;
        var dataFormatado = $(this).val().replace(/[^0-9]/g, '');
        if (dataFormatado.length < 8) {
            $(this).addClass("field-error");
            contaErros(formID);
            return;
        }
        $(this).removeClass("field-error");
        contaErros(formID);
        verificarInputsObrigatorios(etapaID);
    });

    // validação de celular
    celular.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        var celularFormatado = $(this).val().replace(/[^0-9]/g, '');
        if (celularFormatado.length < 11) {
            $(this).addClass("field-error");
            contaErros(formID);
            return;
        }
        $(this).removeClass("field-error");
    });

    // validação de hexadecimal
    hexa.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        if ($(this).val().length < 7) {
            $(this).addClass("field-error");
            contaErros(formID);
            return;
        }
        $(this).removeClass("field-error");
    });

    // validação de cep
    cep.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        var cepFormatado = $(this).val().replace(/[^0-9]/g, '');
        if (cepFormatado.length < 8) {
            $(this).addClass("field-error");
            contaErros(formID);
            return;
        }
        $(this).removeClass("field-error");
        buscaCep($(this).val());
        verificarInputsObrigatorios(formID);
    });

    // validação campos normais
    field.on("keyup", function (e) {
        var formID = e.target.closest("form").id;
        if ($(this).val().length > 1) {
            contaErros(formID);
            return;
        }
    });


    // ##################################################################################################
    // FUNCTIONS PARA VALIDAÇÃO DE CPF, CNPJ E API DE CEP

    // função que envia as requisições de busca CEP
    function sendFetchCEP() {
        $("#loadCep").show();
        return fetch.apply(this, arguments);
    }

    // busca o cep informado
    function buscaCep(cep) {
        const cepFormatado = cep.replace("-", "");
        sendFetchCEP("https://brasilapi.com.br/api/cep/v2/" + cepFormatado).then((resp) => resp.json()).then(function (dados) {

            var formID = $("#field_cep").closest("form").attr("id");

            if (!dados.cep) {
                $(".msg").addClass("on");
                $(".msg .text").text("CEP não encontrado");
                $("#field_cep").addClass("field-error");
                $("#loadCep").hide();
                contaErros(formID);
                return;
            }

            $("#field_logradouro, #field_logradouro_dados").val(dados.street).addClass("input-active");
            $("#field_uf, #field_uf_dados").val(dados.state).addClass("input-active");
            $("#field_cidade, #field_cidade_dados").val(dados.city).addClass("input-active");
            $("#field_bairro, #field_bairro_dados").val(dados.neighborhood).addClass("input-active");

            contaErros(formID);
            verificarInputsObrigatorios(formID);
            $(".msg").removeClass("on");
            $("#loadCep").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    }

    function verifica_cpf_cnpj(valor) {

        // Garante que o valor é uma string
        valor = valor.toString();

        // Remove caracteres inválidos do valor
        valor = valor.replace(/[^0-9]/g, '');

        // Verifica CPF
        if (valor.length === 11) {
            return 'CPF';
        }

        // Verifica CNPJ
        else if (valor.length === 14) {
            return 'CNPJ';
        }

        // Não retorna nada
        else {
            return false;
        }

    } // verifica_cpf_cnpj

    /*
     calc_digitos_posicoes
     
     Multiplica dígitos vezes posições
     
     @param string digitos Os digitos desejados
     @param string posicoes A posição que vai iniciar a regressão
     @param string soma_digitos A soma das multiplicações entre posições e dígitos
     @return string Os dígitos enviados concatenados com o último dígito
    */
    function calc_digitos_posicoes(digitos, posicoes = 10, soma_digitos = 0) {

        // Garante que o valor é uma string
        digitos = digitos.toString();

        // Faz a soma dos dígitos com a posição
        // Ex. para 10 posições:
        //   0    2    5    4    6    2    8    8   4
        // x10   x9   x8   x7   x6   x5   x4   x3  x2
        //   0 + 18 + 40 + 28 + 36 + 10 + 32 + 24 + 8 = 196
        for (var i = 0; i < digitos.length; i++) {
            // Preenche a soma com o dígito vezes a posição
            soma_digitos = soma_digitos + (digitos[i] * posicoes);

            // Subtrai 1 da posição
            posicoes--;

            // Parte específica para CNPJ
            // Ex.: 5-4-3-2-9-8-7-6-5-4-3-2
            if (posicoes < 2) {
                // Retorno a posição para 9
                posicoes = 9;
            }
        }

        // Captura o resto da divisão entre soma_digitos dividido por 11
        // Ex.: 196 % 11 = 9
        soma_digitos = soma_digitos % 11;

        // Verifica se soma_digitos é menor que 2
        if (soma_digitos < 2) {
            // soma_digitos agora será zero
            soma_digitos = 0;
        } else {
            // Se for maior que 2, o resultado é 11 menos soma_digitos
            // Ex.: 11 - 9 = 2
            // Nosso dígito procurado é 2
            soma_digitos = 11 - soma_digitos;
        }

        // Concatena mais um dígito aos primeiro nove dígitos
        // Ex.: 025462884 + 2 = 0254628842
        var cpf = digitos + soma_digitos;

        // Retorna
        return cpf;

    } // calc_digitos_posicoes

    /*
     Valida CPF
     
     Valida se for CPF
     
     @param  string cpf O CPF com ou sem pontos e traço
     @return bool True para CPF correto - False para CPF incorreto
    */
    function valida_cpf(valor) {

        // Garante que o valor é uma string
        valor = valor.toString();

        // Remove caracteres inválidos do valor
        valor = valor.replace(/[^0-9]/g, '');


        // Captura os 9 primeiros dígitos do CPF
        // Ex.: 02546288423 = 025462884
        var digitos = valor.substr(0, 9);

        // Faz o cálculo dos 9 primeiros dígitos do CPF para obter o primeiro dígito
        var novo_cpf = calc_digitos_posicoes(digitos);

        // Faz o cálculo dos 10 dígitos do CPF para obter o último dígito
        var novo_cpf = calc_digitos_posicoes(novo_cpf, 11);

        // Verifica se o novo CPF gerado é idêntico ao CPF enviado
        if (novo_cpf === valor) {
            // CPF válido
            return true;
        } else {
            // CPF inválido
            return false;
        }

    } // valida_cpf

    /*
     valida_cnpj
     
     Valida se for um CNPJ
     
     @param string cnpj
     @return bool true para CNPJ correto
    */
    function valida_cnpj(valor) {

        // Garante que o valor é uma string
        valor = valor.toString();

        // Remove caracteres inválidos do valor
        valor = valor.replace(/[^0-9]/g, '');


        // O valor original
        var cnpj_original = valor;

        // Captura os primeiros 12 números do CNPJ
        var primeiros_numeros_cnpj = valor.substr(0, 12);

        // Faz o primeiro cálculo
        var primeiro_calculo = calc_digitos_posicoes(primeiros_numeros_cnpj, 5);

        // O segundo cálculo é a mesma coisa do primeiro, porém, começa na posição 6
        var segundo_calculo = calc_digitos_posicoes(primeiro_calculo, 6);

        // Concatena o segundo dígito ao CNPJ
        var cnpj = segundo_calculo;

        // Verifica se o CNPJ gerado é idêntico ao enviado
        if (cnpj === cnpj_original) {
            return true;
        }

        // Retorna falso por padrão
        return false;

    } // valida_cnpj

    /*
     valida_cpf_cnpj
     
     Valida o CPF ou CNPJ
     
     @access public
     @return bool true para válido, false para inválido
    */
    function valida_cpf_cnpj(valor) {

        // Verifica se é CPF ou CNPJ
        var valida = verifica_cpf_cnpj(valor);

        // Garante que o valor é uma string
        valor = valor.toString();

        // Remove caracteres inválidos do valor
        valor = valor.replace(/[^0-9]/g, '');


        // Valida CPF
        if (valida === 'CPF') {
            // Retorna true para cpf válido
            return valida_cpf(valor);
        }

        // Valida CNPJ
        else if (valida === 'CNPJ') {
            // Retorna true para CNPJ válido
            return valida_cnpj(valor);
        }

        // Não retorna nada
        else {
            return false;
        }

    } // valida_cpf_cnpj

    /*
     formata_cpf_cnpj
     
     Formata um CPF ou CNPJ
    
     @access public
     @return string CPF ou CNPJ formatado
    */
    function formata_cpf_cnpj(valor) {

        // O valor formatado
        var formatado = false;

        // Verifica se é CPF ou CNPJ
        var valida = verifica_cpf_cnpj(valor);

        // Garante que o valor é uma string
        valor = valor.toString();

        // Remove caracteres inválidos do valor
        valor = valor.replace(/[^0-9]/g, '');


        // Valida CPF
        if (valida === 'CPF') {

            // Verifica se o CPF é válido
            if (valida_cpf(valor)) {

                // Formata o CPF ###.###.###-##
                formatado = valor.substr(0, 3) + '.';
                formatado += valor.substr(3, 3) + '.';
                formatado += valor.substr(6, 3) + '-';
                formatado += valor.substr(9, 2) + '';

            }

        }

        // Valida CNPJ
        else if (valida === 'CNPJ') {

            // Verifica se o CNPJ é válido
            if (valida_cnpj(valor)) {

                // Formata o CNPJ ##.###.###/####-##
                formatado = valor.substr(0, 2) + '.';
                formatado += valor.substr(2, 3) + '.';
                formatado += valor.substr(5, 3) + '/';
                formatado += valor.substr(8, 4) + '-';
                formatado += valor.substr(12, 14) + '';

            }

        }

        // Retorna o valor 
        return formatado;

    } // formata_cpf_cnpj
}

function validaSenha(btn, field) {
    var botao = $(btn);
    var senha = $(field);
    var passo1, passo2, passo3, passo4, valorSenha = senha.val();

    // regra de 8 caracteres
    if (valorSenha.match(/.{8,}/)) {
        $("#oitoCaracteres .icone").removeClass("red").addClass("green");
        $("#oitoCaracteres .icone span").text("check");
        passo1 = true;
    } else {
        $("#oitoCaracteres .icone").removeClass("green").addClass("red");
        $("#oitoCaracteres .icone span").text("close");
        passo1 = false;
    }

    // regra 1 letra maiúscula
    if (valorSenha.match(/[A-Z]{1,}/)) {
        $("#letraMaiuscula .icone").removeClass("red").addClass("green");
        $("#letraMaiuscula .icone span").text("check");
        passo2 = true;
    } else {
        $("#letraMaiuscula .icone").removeClass("green").addClass("red");
        $("#letraMaiuscula .icone span").text("close");
        passo2 = false;
    }

    // regra 1 número
    if (valorSenha.match(/[0-9]{1,}/)) {
        $("#numero .icone").removeClass("red").addClass("green");
        $("#numero .icone span").text("check");
        passo3 = true;
    } else {
        $("#numero .icone").removeClass("green").addClass("red");
        $("#numero .icone span").text("close");
        passo3 = false;
    }

    // regra caracteres especial
    if (valorSenha.match(/[#?!@$%^&*-]{1,}/)) {
        $("#caractereEspecial .icone").removeClass("red").addClass("green");
        $("#caractereEspecial .icone span").text("check");
        passo4 = true;
    } else {
        $("#caractereEspecial .icone").removeClass("green").addClass("red");
        $("#caractereEspecial .icone span").text("close");
        passo4 = false;
    }

    // validar se as regras foram cumpridas
    if (passo1 && passo2 && passo3 && passo4) {
        botao.removeAttr("disabled");
        senha.removeClass("field-error");
    } else {
        botao.attr("disabled", true);
        senha.addClass("field-error");
    }
}