$(function(){

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoVideo");
    verificaInputsRequired("formNovoVideo");
    validationForm("formDadosVideo");
    verificaInputsRequired("formDadosVideo");

    var toolbarOptions = [
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        ['bold', 'italic', 'underline', 'strike'],
        ['link'],
        [{ 'list': 'ordered'},{'list':'bullet'}, { 'align': []}],
        ['clean']
    ];

    var options = {
        placeholder: 'Descrição do vídeo...',
        theme: 'snow',
        modules: {
            toolbar: toolbarOptions
        }
    };

    var quill = new Quill(".editor", options);

    var quillDados = new Quill(".editor-dados", options);


    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarVideo").click(function () {
        abreModal("modalNovoVideo");
    });

    $("#fechaModalNovoVideo").click(() => {
        $("#modalNovoVideo").hide();
    });

    $("body").on("keyup click",".editor .ql-editor", function(){
        $("#callback_video").val($(this).html());
        if($("#callback_video").val() == "<p><br></p>"){
            $("#btnCadastraVideo").attr("disabled", true);
        }else{
            $("#btnCadastraVideo").attr("disabled", false);
        }
    });

    $("body").on("keyup click",".editor-dados .ql-editor", function(){
        $("#callback_video_dados").val($(this).html());
        if($("#callback_video_dados").val() == "<p><br></p>"){
            $("#btnAtualizaVideo").attr("disabled", true);
        }else{
            $("#btnAtualizaVideo").attr("disabled", false);
        }
    });

    function sendFetchDados() {
        $("#btnCadastraVideo .load").show();
        $("#btnCadastraVideo .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoVideo").submit(function (e) {
        e.preventDefault();

        if($("#field_titulo").val().length === 0){
            $("#field_titulo").val($("#callback_video").val().replace(/<[^>]*>/g," ").replace(/\s{2,}/g," ").trim().split(".")[0]).addClass("input-active");
        }

        sendFetchDados("./controller/cadastra_video.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraVideo .text").show();
                $("#btnCadastraVideo .load").hide();
                return;
            }
            
            $("#btnCadastraVideo .text").show();
            $("#btnCadastraVideo .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosVideo .load-detalhes").show();
        return fetch.apply(this, arguments);
    }


    $("#listaVideo").on("click",".abre-detalhes", function () {

        abreModal("modalDadosVideo");
        const idEstabelecimento = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_video.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            console.log(dados);

            $("#field_titulo_dados").val(dados.titulo).addClass("input-active");
            $("#modalDadosVideo .ql-editor").html(dados.descricao);
            $("#modalDadosVideo #callback_video_dados").val(dados.descricao);
            $("#field_link_dados").val(dados.link).addClass("input-active");

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";

            $("#field_hidden_status").val(dados.status);
            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");

            $("#btnAtualizaVideo").data("id", dados.id);
            
            $("#modalDadosVideo .load-detalhes").hide();
            $("#formDadosVideo").removeClass("hide");

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosVideo").click(() => {
        closeModalVideo();
    });

    function closeModalVideo(){
        $("#modalDadosVideo .load-detalhes").show();
        $("#modalDadosVideo").hide();
        $("#formDadosVideo").addClass("hide");
        $("#btnAtualizaVideo").attr("disabled", true);
    }

    function sendFetchAtualizaDados() {
        $("#btnAtualizaVideo .load").show();
        $("#btnAtualizaVideo .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosVideo").submit(function (e) {
        e.preventDefault();

        const idVideo = $("#btnAtualizaVideo").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_video.php?id="+idVideo, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaVideo .text").show();
                $("#btnAtualizaVideo .load").hide();
                return;
            }
            
            $("#btnAtualizaVideo .text").show();
            $("#btnAtualizaVideo .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            closeModalVideo();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#listaVideo").on("click",".exclui-video", function () {
        const idVideo = $(this).closest("tr").data("id");
        $("#btnExcluiVideo").data("id",idVideo);
        abreModal("modalExcluiVideo");
    });

    $("#btnFechaModalExcluiVideo").click(()=>{
        $("#modalExcluiVideo").hide();
    });

    function sendFetchExcluiVideo() {
        $("#btnExcluiVideo .load").show();
        $("#btnExcluiVideo .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#btnExcluiVideo").click(function (e) {
        e.preventDefault();

        const idVideo = $(this).data("id");

        sendFetchExcluiVideo("./controller/deleta_video.php?id="+idVideo).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnExcluiVideo .text").show();
                $("#btnExcluiVideo .load").hide();
                return;
            }
            
            $("#btnExcluiVideo .text").show();
            $("#btnExcluiVideo .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
        $("#btnAtualizaVideo").attr("disabled", false);
    });

    $("#pesquisaLivreCards").on("input change", function () {
        $(".videos-list-flex .card").removeClass("result-on");

        if ($(this).val() != "") {
            $(".videos-list-flex .card").hide();
            $(".videos-list-flex .card:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $(".videos-list-flex .card, .videos-list-flex").show();
            $("#emptyVideo").addClass("hide");
        }
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $("#emptyVideo").removeClass("hide");
            $(".videos-list-flex").hide();
        } else {
            $("#emptyVideo").addClass("hide");
            $(".videos-list-flex").show();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

});