<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Usuários - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/usuarios.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="usuarios" data-route="usuarios">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main usuarios">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Usuários
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarUsuario">
                    <span class="load" id="load"></span>
                    <span class="text">Adicionar novo</span>
                </div>
            </div>
            <section class="filtros mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaLivre" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Nome ou e-mail</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_cnpj" id="pesquisaCNPJ" data-key="live" class="input icon-right mask-cpf">
                                            <label for="pesquisaCNPJ">CPF</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                        <div class="input-content">
                                            <select class="select wide input-active" id="selectStatus">
                                                <option value="Todos">Todos</option>
                                                <option value="0">Inativo</option>
                                                <option value="1">Ativo</option>
                                                <option value="2">Pendente</option>
                                            </select>
                                            <label for="selectStatus">Status</label>
                                        </div>
                                        <button type="button" class="botao secondary auto-width" id="resetaFiltros">
                                            <span class="text">Limpar</span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <section class="estabelecimentos-list">
                <div class="card">
                    <div class="empty hide">
                        <?php require_once("./assets/img/empty_usuarios.svg"); ?>
                        <p>Os usuários aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="load-alt center" id="loadUsuarios"></div>
                    <div class="table-scroll hide" id="tableUsuarios">
                        <table>
                            <thead>
                                <tr>
                                    <!-- <th>#</th> -->
                                    <th>Foto</th>
                                    <th>Nome</th>
                                    <th>CPF</th>
                                    <th>E-mail</th>
                                    <th class="adm">Perfil</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaUsuarios">
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
        <?php require_once("model/body/modal_cadastro_usuario.php"); ?>
        <?php require_once("model/body/modal_dados_usuario.php"); ?>
        <?php require_once("model/body/modal_altera_status_usuario.php"); ?>
        <?php require_once("model/body/modal_envia_email_usuario.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>